<?php
/**
 * Plugin Name: درگاه پرداخت بانک ملی (سداد)
 * Description: پرداخت امن از طریق درگاه بانک ملی 
 * Version: 2.2.2
 * Author: https://sadrcod.ir
 * Author URI: https://sadrcod.ir
 * Text Domain: sadad-bank-melli (sadrcod.ir)
 */

if ( ! defined( 'ABSPATH' ) ) exit;

define('SADAD_WOO_FINAL_PATH', plugin_dir_path(__FILE__));
define('SADAD_WOO_FINAL_URL', plugin_dir_url(__FILE__));


// HPOS compatibility
add_action( 'before_woocommerce_init', function() {
    if ( class_exists( \Automattic\WooCommerce\Utilities\FeaturesUtil::class ) ) {
        \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', __FILE__, true );
    }
});

// Activation: create DB table
register_activation_hook( __FILE__, function() {
    require_once SADAD_WOO_FINAL_PATH . 'includes/class-sadad-db.php';
    Sadad_Woo_DB::maybe_create_table();
});

// Load includes and register gateway after plugins_loaded
add_action('plugins_loaded', function() {
    if ( ! class_exists('WooCommerce') ) {
        add_action('admin_notices', function() {
            echo '<div class="notice notice-error"><p><strong>Sadad Gateway:</strong> WooCommerce is required.</p></div>';
        });
        return;
    }

    require_once SADAD_WOO_FINAL_PATH . 'includes/class-sadad-db.php';
    require_once SADAD_WOO_FINAL_PATH . 'includes/class-wc-gateway-sadad.php';

    add_filter('woocommerce_payment_gateways', function($methods){
        $methods[] = 'WC_Gateway_Sadad_Final';
        return $methods;
    });
});

// REST endpoint for callback: /wp-json/sadad/v1/verify
add_action('rest_api_init', function() {
    register_rest_route('sadad/v1', '/verify', array(
        'methods' => 'POST',
        'callback' => 'sadad_final_rest_verify',
        'permission_callback' => '__return_true',
    ));
});

function sadad_final_rest_verify( WP_REST_Request $request ) {
    $params = $request->get_params();
    if ( empty($params) ) {
        $json = json_decode( $request->get_body(), true );
        if ( json_last_error() === JSON_ERROR_NONE && is_array($json) ) {
            $params = $json;
        }
    }

    if ( empty($params['OrderId']) || empty($params['token']) ) {
        return new WP_REST_Response('<h3>Invalid callback data.</h3>', 200);
    }

    $order_id = intval( $params['OrderId'] );
    $token = sanitize_text_field( $params['token'] );

    // Ensure gateway class available
    if ( ! class_exists('WC_Gateway_Sadad_Final') ) {
        require_once SADAD_WOO_FINAL_PATH . 'includes/class-wc-gateway-sadad.php';
    }
    $gateway = new WC_Gateway_Sadad_Final();

    // Prepare SignData for Verify API
    try {
        $signData = $gateway->encrypt_sign_data( $token );
    } catch ( Exception $e ) {
        $signData = '';
    }

    $verify_data = array(
        'token' => $token,
        'SignData' => $signData
    );

    $verify_resp = wp_remote_post('https://sadad.shaparak.ir/api/v0/Advice/Verify', array(
        'headers' => array('Content-Type' => 'application/json'),
        'body' => wp_json_encode($verify_data),
        'timeout' => 45
    ));

    $succeed = false;
    $verify_json = array();
    if ( ! is_wp_error($verify_resp) ) {
        $body = wp_remote_retrieve_body($verify_resp);
        $verify_json = json_decode($body, true) ?: array();
        if ( isset($verify_json['ResCode']) && $verify_json['ResCode'] == "0" ) {
            $succeed = true;
        }
    }

    // Record transaction
    require_once SADAD_WOO_FINAL_PATH . 'includes/class-sadad-db.php';
    $insert = array(
        'order_id' => $order_id,
        'token' => $token,
        'res_code' => isset($verify_json['ResCode']) ? sanitize_text_field($verify_json['ResCode']) : '',
        'succeed' => $succeed ? 1 : 0,
        'description' => isset($verify_json['Description']) ? sanitize_textarea_field($verify_json['Description']) : '',
        'amount' => isset($verify_json['Amount']) ? sanitize_text_field($verify_json['Amount']) : '',
        'retrival_ref_no' => isset($verify_json['RetrivalRefNo']) ? sanitize_text_field($verify_json['RetrivalRefNo']) : '',
        'system_trace_no' => isset($verify_json['SystemTraceNo']) ? sanitize_text_field($verify_json['SystemTraceNo']) : '',
        'vr_order_id' => isset($verify_json['OrderId']) ? sanitize_text_field($verify_json['OrderId']) : '',
        'card_holder_full_name' => isset($verify_json['CardHolderFullName']) ? sanitize_text_field($verify_json['CardHolderFullName']) : '',
        'transaction_date' => isset($verify_json['TransactionDate']) ? sanitize_text_field($verify_json['TransactionDate']) : '',
        'raw_json' => wp_json_encode($verify_json, JSON_UNESCAPED_UNICODE)
    );
    Sadad_Woo_DB::insert_transaction($insert);
    
    // Update Woo order
    if ( function_exists('wc_get_order') ) {
        $order = wc_get_order( $order_id );
        if ( $order ) {
            if ( $succeed ) {
                if ( ! $order->is_paid() ) {
                    $order->payment_complete( $verify_json['RetrivalRefNo'] ?? '' );
                }
                $order->update_status('processing');
            } else {
                $order->update_status('failed', 'Sadad verify failed.');
            }

            $order->add_order_note(
    "تراکنش موفق بود.<br>" .
    "کد رهگیری (شماره مرجع تراکنش): {$verify_json['RetrivalRefNo']}<br>" .
    "شماره پیگیری داخلی تراکنش: {$verify_json['SystemTraceNo']}<br>" .
    "شماره سفارش: {$verify_json['OrderId']}", true
            );


             // ✅ Redirect to Woo order-received page
            $redirect_url = $order->get_checkout_order_received_url();
            wp_safe_redirect( $redirect_url );
            exit;
        }
    }
if(!$succeed){
        // Return HTML result page
    $home = esc_url( home_url('/') );
    $title = $succeed ? 'پرداخت با موفقیت انجام شد' : 'پرداخت ناموفق بود.';
    $bg = $succeed ? '#e6ffed' : '#fff0f0';
    $icon = $succeed ? '&#10004;' : '&#10008;';
    $trackingN = $succeed ? $verify_json['SystemTraceNo'] : '';
    $postTransactionMessage = $succeed ? $gateway->success_message : $gateway->failure_message;
    $html = "<!doctype html><html><head><meta charset='utf-8'><title>{$title}</title>
<style>
body{margin:0;padding:0;background:{$bg};font-family:Tahoma,Arial,Helvetica,sans-serif}
.wrap{min-height:100vh;display:flex;align-items:center;justify-content:center}
.card{background:#fff;padding:30px;border-radius:10px;box-shadow:0 6px 30px rgba(0,0,0,0.12);text-align:center;max-width:520px;margin:20px}
h1{font-size:22px;margin:0 0 10px}
p{color:#666;margin:0 0 20px}
a.btn{display:inline-block;background:#007cba;color:#fff;padding:12px 22px;border-radius:6px;text-decoration:none}
</style>
</head><body><div class='wrap'><div class='card'><h1 style='font-size:26px'>{$icon} {$title}</h1><p></p><a class='btn' href='{$home}'>{$postTransactionMessage}</a><p></p><span>شماره تراکنش {$trackingN}</span></div></div></body></html>";

    // return new WP_REST_Response($html, 200, array('Content-Type' => 'text/html; charset=utf-8'));
    header('Content-Type: text/html; charset=utf-8');
    echo $html;
    exit;
}

}


add_action('admin_menu', 'sadrcod_add_admin_menu', 99); // Priority 99 to run after WC


function sadrcod_add_admin_menu() {
    if ( ! current_user_can('manage_options') ) return;

    add_menu_page(
        'پیشخوان پستی صدر',            // Page title
        'پیشخوان پستی صدر',                 // Menu title
        'manage_options',          // Capability
        'sadrcod-gateway',      // Menu slug
        'sadrcod_render_admin_page', // Callback function
        'dashicons-location', // Icon (optional)
        // plugins_url('includes/assets/images/sadrcod-logo.png', __FILE__), // مسیر تصویر
        56                         // Position
    );
}

function sadrcod_render_admin_page() {
    $image_url = plugins_url('includes/assets/images/sadrcod-banner.jpeg', __FILE__);
    echo '<div style="text-align:center; margin-top:50px;">';
    echo '<img src="' . esc_url($image_url) . '" alt="Sadrcod.ir" style="max-width:100%; height:auto;">';
    echo '</div>';
}

?>