<?php
if ( ! defined( 'ABSPATH' ) ) exit;
if ( ! class_exists('WC_Payment_Gateway') ) return;

class WC_Gateway_Sadad_Final extends WC_Payment_Gateway {
    public function __construct() {
        $this->id = 'melli_bank_sadad';
        // $this->id = 'sadad_final';
        $this->method_title = __('درگاه پرداخت بانک ملی', 'sadad-woo');
        $this->method_description = __('پرداخت امن از طریق درگاه بانک ملی', 'sadad-woo');
        $this->icon = plugins_url('assets/images/sadad-logo.png', __FILE__); 
        $this->has_fields = false;
        $this->supports = array('products');
        $this->init_form_fields();
        $this->init_settings();
        $this->title = $this->get_option('title', "درگاه پرداخت بانک ملی ایران");
        $this->description = $this->get_option('description', "پرداخت امن به وسیله کلیه کارت های عضو شتاب از طریق درگاه سداد ملی جدید");
        $this->enabled = $this->get_option('enabled');
        $this->terminal_id = $this->get_option('terminal_id');
        $this->merchant_id = $this->get_option('merchant_id');
        $this->merchant_key = $this->get_option('merchant_key');
        $this->success_message = $this->get_option('success_message');
        $this->failure_message = $this->get_option('failure_message');
        $this->token_url = "https://sadad.shaparak.ir/api/v0/Request/PaymentRequest";
        $this->purchase_url = "https://sadad.shaparak.ir/Purchase/Index";
        $this->callback_url = $this->get_option('callback_url');
        add_action('woocommerce_update_options_payment_gateways_' . $this->id, array($this, 'process_admin_options'));
        add_action('woocommerce_receipt_' . $this->id, array($this, 'receipt_page'));
    }

    public function init_form_fields() {
        $this->form_fields = array(
            'enabled' => array('title'=>__('فعال/غیرفعال','sadad-woo'),'type'=>'checkbox','label'=>__('فعال سازی','sadad-woo'),'default'=>'no'),
            'title' => array('title'=>__('عنوان','sadad-woo'),'type'=>'text','default'=>'درگاه پرداخت بانک ملی ایران'),
            'description' => array('title'=>__('توضیحات','sadad-woo'),'type'=>'textarea','default'=>'پرداخت امن به وسیله کلیه کارت های عضو شتاب از طریق درگاه سداد ملی جدید'),
            'terminal_id' => array('title'=>__('شماره ترمینال','sadad-woo'),'type'=>'text'),
            'merchant_id' => array('title'=>__('Merchant ID','sadad-woo'),'type'=>'text'),
            'merchant_key' => array('title'=>__('Merchant Key (Base64)','sadad-woo'),'type'=>'password'),
            // 'token_url' => array('title'=>__('Token API URL','sadad-woo'),'type'=>'text'),
            // 'purchase_url' => array('title'=>__('Purchase URL','sadad-woo'),'type'=>'text','default'=>'https://sadad.shaparak.ir/Purchase/Index'),
            'success_message' => array('title'=>__('پیام پرداخت موفق','sadad-woo'),'type'=>'textarea','default'=>'با تشکر از شما. سفارش شما با موفقیت پرداخت شد'),
            'failure_message' => array('title'=>__('پیام پرداخت ناموفق','sadad-woo'),'type'=>'textarea','default'=>'پرداخت شما ناموفق بوده است. لطفا مجددا تلاش نمایید یا در صورت بروز اشکال با مدیر سایت تماس بگیرید'),
            'callback_url' => array('title'=>__('Callback ','sadad-woo'),'type'=>'text','description'=> __('در صورت خالی گذاشتن, از وب هوک پیش فرض وردپرس استفاده می شود.','sadad-woo'))
        );
    }

    public function admin_options() {
        // echo '<h2>'.esc_html($this->get_method_title()).'</h2>';
        // echo wp_kses_post(wpautop($this->get_method_description()));
        // echo '<p><strong>Callback endpoint:</strong> <code>'.esc_html(rest_url('sadad/v1/verify')).'</code></p>';
        $image_url = plugins_url('assets/images/sadrcod-logo.png', __FILE__);
        echo '<div style="text-align:center; margin: 20px 0;">';
        echo '<img src="' . esc_url($image_url) . '" style="max-width:300px; height:auto;" alt="واسط پستی صدر">';
        echo '<p style="font-size:18px; font-weight:bold; margin-top:10px;">توسعه یافته با &#x2764;&#xFE0F;
         توسط شرکت واسط پستی صدر، ارایه دهنده خدمات ارسال با پست و تیپاکس با قیمتی ارزانتر از باجه</p>';
        echo '</div>';
        parent::admin_options();
    }

    // public function is_available() {
    //     if ($this->enabled !== 'yes') return false;
    //     return parent::is_available();
    // }

    // 3DES-ECB-PKCS7 encryption (base64 output)
    public function encrypt_sign_data($plain) {
        $key = base64_decode($this->merchant_key);
        if ($key === false) throw new Exception('Invalid merchant key (base64).');
        $encrypted = openssl_encrypt($plain, 'DES-EDE3-ECB', $key, OPENSSL_RAW_DATA);
        if ($encrypted === false) throw new Exception('Encryption failed.');
        return base64_encode($encrypted);
    }

    public function process_payment($order_id) {
        $order = wc_get_order($order_id);
        if (!$order) {
            wc_add_notice(__('Invalid order','sadad-woo'),'error');
            return array('result'=>'fail');
        }
        $amount = (int) round($order->get_total());
        $orderCode = (string) $order->get_id();

        try {
            $payload = $this->terminal_id . ';' . $orderCode . ';' . $amount;
            $signData = $this->encrypt_sign_data($payload);

            $callback = $this->callback_url;
            if (empty($callback)) $callback = rest_url('sadad/v1/verify');

            $data = array(
                'TerminalId' => $this->terminal_id,
                'MerchantId' => $this->merchant_id,
                'Amount' => $amount,
                'signData' => $signData,
                'ReturnUrl' => $callback,
                'LocalDateTime' => current_time('mysql'),
                'OrderId' => $orderCode
            );

            $resp = wp_remote_post($this->token_url, array(
                'headers' => array('Content-Type'=>'application/json'),
                'body' => wp_json_encode($data),
                'timeout' => 45
            ));

            if (is_wp_error($resp)) throw new Exception($resp->get_error_message());
            $code = wp_remote_retrieve_response_code($resp);
            $body = wp_remote_retrieve_body($resp);
            $json = json_decode($body, true);
            if ($code !== 200 || !is_array($json)) throw new Exception('Bad token response: ' . $body);

            if (isset($json['ResCode']) && (string)$json['ResCode'] === '0' && !empty($json['Token'])) {
                $order->update_status('pending', __('Redirected to Sadad','sadad-woo'));
                $redirect = add_query_arg('token', sanitize_text_field($json['Token']), $this->purchase_url);
                return array('result'=>'success','redirect'=>$redirect);
            }

            throw new Exception('Token request failed. ResCode: ' . ($json['ResCode'] ?? 'unknown'));
        } catch (Exception $e) {
            wc_get_logger()->error('[Sadad] ' . $e->getMessage(), array('source'=>'sadad'));
            wc_add_notice(__('Payment initialization failed: ','sadad-woo') . $e->getMessage(), 'error');
            return array('result'=>'fail');
        }
    }

    public function receipt_page($order) {
        echo '<p>' . __('Redirecting to Sadad...', 'sadad-woo') . '</p>';
    }
}
?>