<?php
if ( ! defined( 'ABSPATH' ) ) exit;
class Sadad_Woo_DB {
    public static function table_name() {
        global $wpdb;
        return $wpdb->prefix . 'sadad_transactions';
    }
    public static function maybe_create_table() {
        global $wpdb;
        $table = self::table_name();
        $charset = $wpdb->get_charset_collate();
        $sql = "CREATE TABLE IF NOT EXISTS `$table` (
            `id` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
            `order_id` BIGINT NULL,
            `token` VARCHAR(255) NULL,
            `res_code` VARCHAR(50) NULL,
            `succeed` TINYINT NULL,
            `description` TEXT NULL,
            `amount` VARCHAR(50) NULL,
            `retrival_ref_no` VARCHAR(100) NULL,
            `system_trace_no` VARCHAR(100) NULL,
            `vr_order_id` VARCHAR(100) NULL,
            `card_holder_full_name` VARCHAR(255) NULL,
            `transaction_date` VARCHAR(100) NULL,
            `raw_json` LONGTEXT NULL,
            `created_at` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
            PRIMARY KEY (`id`),
            KEY `order_idx` (`order_id`)
        ) $charset;";
        require_once ABSPATH . 'wp-admin/includes/upgrade.php';
        dbDelta($sql);
    }
    public static function insert_transaction($data) {
        global $wpdb;
        $table = self::table_name();
        $wpdb->insert($table, $data);
    }
}
?>