<?php
/**
 * Plugin Name: افزونه حمل و نقل ووکامرس صدر
 * Plugin URI: https://sadrcod.ir/
 * Description: افزونه قدرتمند حمل و نقل ووکامرس با قابلیت ارسال از طریق پست پیشتاز، سفارشی، پیک موتوری و تیپاکس
 * Version: 1.4.7
 * Author: SadrCod
 * Author URI: https://sadrcod.ir/
 * WC requires at least: 5.0.0
 * WC tested up to: 7.8.2
 */

defined( 'ABSPATH' ) || exit;

if ( ! defined( 'MBGHI_VERSION' ) ) define( 'MBGHI_VERSION', '1.0.0' );
if ( ! defined( 'MBGHI_DIR' ) ) define( 'MBGHI_DIR', __DIR__ );
if ( ! defined( 'MBGHI_FILE' ) ) define( 'MBGHI_FILE', __FILE__ );
if ( ! defined( 'MBGHI_URL' ) ) define( 'MBGHI_URL', plugin_dir_url( __FILE__ ) );


function MBGHI() {
    return MBGHI_Core::instance();
}

add_action( 'before_woocommerce_init', function() {
    if ( class_exists( \Automattic\WooCommerce\Utilities\FeaturesUtil::class ) ) {
        \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', __FILE__, true );
    }
} );

add_action( 'woocommerce_loaded', function () {
	include( 'inc/cls-ow.php' );
	include( 'inc/cls-ajax.php' );
	include( 'inc/cls-cart.php' );
	include( 'inc/cls-install.php' );
	include( 'inc/cls-sadr.php' );
	include( 'inc/cls-order.php' );
	include( 'inc/cls-product.php' );
	include( 'inc/cls-tools.php' );
	include( 'inc/cls-status.php' );
	include( 'inc/admin/cls-admin.php' );
	include( 'inc/wc-shipping-method-description/shipping-method-description-for-woocommerce.php' );
}, 20 );

register_activation_hook(MBGHI_FILE, function () {

    $attributes = wc_get_attribute_taxonomies();
    $attributes = wp_list_pluck( $attributes, 'attribute_name' );

    if ( ! in_array( 'szd', $attributes ) ) {
        wc_create_attribute( array( 'name' => 'سایز', 'slug' => 'szd' ) );
    }

	file_put_contents(MBGHI_DIR . '/.activated', '');
});

// Related functionality has been moved t cls-product.php
/*
add_action( 'wp_loaded', function () {
	include( 'inc/cls-cron.php' );
});
 */
