<?php
defined( 'ABSPATH' ) || exit;

if ( class_exists( 'WC_Forehand_Method' ) ) {
	return;
}

#[\AllowDynamicProperties]
class WC_Forehand_Method extends MBGHI_Shipping_Method {

	const INSURANCE = 8000;

	const SERVICE = 16000;

	const TAX = 9;

	public function __construct( $instance_id = 0 ) {

		$this->id                 = 'WC_Forehand_Method';
		$this->instance_id        = absint( $instance_id );
		$this->method_title       = __( 'پست صدر' );
		$this->method_description = __( 'ارسال کالا با استفاده از پست صدر' );

		parent::__construct();
	}

	public function init() {

		parent::init();

		$this->extra_cost         = $this->get_option( 'extra_cost', 0 );
		$this->extra_cost_percent = $this->get_option( 'extra_cost_percent', 0 );
		// $this->source_state       = $this->get_option( 'source_state' );

		$this->tax_dscount       = $this->get_option( 'tax_dscount' );
		$this->shipping_discount       = $this->get_option( 'shipping_discount' );
		$this->service_dscount       = $this->get_option( 'service_dscount' );
		// $this->packageWeight       = $this->get_option( 'packageWeight' );
		$this->shipping_sdr_method       = $this->get_option( 'shipping_sdr_method' );
		// $this->description       = $this->get_option( 'description' );


		add_action( 'woocommerce_update_options_shipping_' . $this->id, [ $this, 'process_admin_options' ] );
	}

	public function init_form_fields() {

		$this->instance_form_fields += [
			'extra_cost'         => [
				'title'       => 'هزینه های اضافی',
				'type'        => 'text',
				'description' => 'هزینه های اضافی علاوه بر نرخ پستی را می توانید وارد نمائید، (مثل: هزینه های بسته بندی و ... ) مبلغ ثابت را به ریال وارد نمائید',
				'default'     => 0,
				'desc_tip'    => true,
			],
			// 'description'         => [
			// 	'title'       => 'توضیحات نوع حمل و نقل',
			// 	'type'        => 'text',
			// 	'description' => 'توضیحی راجب شیوه حمل و نقل اضافه کنید، مثل 3 تا 5 روز کاری',
			// 	'default'     => 'تحویل 3 تا 5 روز کاری.',
			// 	'desc_tip'    => true,
			// ],
			'extra_cost_percent' => [
				'title'       => 'هزینه های اضافی به درصد',
				'type'        => 'text',
				'description' => 'هزینه های اضافی علاوه بر نرخ پستی را می توانید به درصد وارد نمائید (مثال: برای 2%، عدد 2 را وارد نمائید)',
				'default'     => 0,
				'desc_tip'    => true,
			],
			'shipping_sdr_method'       => [
				'title'       => 'شیوه ارسال',
				'type'        => 'select',
				'description' => 'لطفا در این قسمت شیوه ای که کالا می شود را انتخاب نمائید',
				'options'     => array(
					'pishtaz' => 'پست پیشتاز',
                    'vije'  => 'پست ویژه',
				),
				'desc_tip'    => true,
			],
		];
	}

	public function is_available( $package = [] ): bool {

		$weight = MBGHI_Cart::get_weight();

		if ( $weight > MBGHI()->get_option( 'tools.post_weight_limit', 30000 ) ) {
			$this->is_available = false;
		}

		return parent::is_available( $package );
	}

	public function calculate_shipping( $package = [] ) {
		if ($this->free_shipping($package)) {
			return;
		}

		$cost = 0;
		$weight = $this->cart_weight;

		$mb_options = get_option('MBGHI_sadr');

        $base_url = 'https://sadrcod.com:5001';
        if ( isset( $mb_options['ow_base_url'] ) && $mb_options['ow_base_url'] ) {
            $base_url = sanitize_url( $mb_options['ow_base_url'] );
        }

        if (!empty($mb_options['ow_username']) && !empty($mb_options['ow_password'])) {
            $server_output = wp_remote_post( "{$base_url}/api/security/token/new", array(
                'headers'     => [
                    'Content-Type' => 'application/json',
                ],
                'body' => wp_json_encode( array(
                    'username' => $mb_options['ow_username'],
                    'password' => $mb_options['ow_password'],
                ) ),
            ) );

            if ( ! is_wp_error( $server_output ) && $server_output['response']['code'] == 200 ) {
                if (array_key_exists('ow_api_token', $mb_options)) {
                    unset($mb_options['ow_api_token']);
                }

                $server_output = json_decode( $server_output['body'] );
                $mb_options['ow_api_token'] = $server_output->token;
                update_option('MBGHI_sadr', $mb_options);
            }
		}

		$ow_zarib = 1;
		$cSymbol = get_woocommerce_currency_symbol();
		if ($cSymbol == "IRT" || $cSymbol == "تومان") {
			$ow_zarib = 10;
		}
		$ow_amount = $this->cart_total * $ow_zarib;
		
		if (intval($ow_amount) < 1) $ow_amount = 1000000 * $ow_zarib;
		$packWeight = 0;
		if (intval($packWeight) < 1) $packWeight = intval($mb_options['pack_weight']);
		if (intval($weight) < 1) $weight = intval($mb_options['product_weight']);
		// var_dump($weight);

		$ow_city = $package['destination']['city'];
		if ($ow_city == 0) $ow_city = 2;
		$ow_city = get_term($ow_city);
		$ow_city = $ow_city->slug;
		if ($ow_city == 0) $ow_city = 2;

		$prepaid = true;
		$payment_method = WC()->session->get( 'chosen_payment_method' );
		if ($payment_method == 'cod') {
			$prepaid = false;
		}

		$ch = curl_init();
		$data = array(
			'weight' => intval($weight),
			'price' => $ow_amount,
			'packagingWeight' => $packWeight,
			'prepaid' => $prepaid,
			'cityCode' => intval($ow_city)
		);
		
		curl_setopt_array( $ch, [
			CURLOPT_URL            => "{$base_url}/ws/v006/getDeliveryCostV2",
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING       => "",
			CURLOPT_MAXREDIRS      => 1,
			CURLOPT_TIMEOUT        => 10,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION   => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST  => "POST",
			CURLOPT_POSTFIELDS     => json_encode($data),
			CURLOPT_HTTPHEADER     => [
				"Content-type: application/json",
				"Accept: application/json",
				"X-ATJ-Username: " . $mb_options['ow_username'],
				"X-ATJ-Auth-Token: " . $mb_options['ow_api_token'],
			],
		] );
		$server_output = curl_exec($ch);
		$server_output = json_decode($server_output);

		if (isset($server_output->data)) {
			switch ($this->shipping_sdr_method) {
				case 'sefareshi':
					$cost = $server_output->data->normalDeliveryAndTaxCost;
					break;
				case 'peyk':
					$cost = $server_output->data->byCourierDeliveryAndTaxCost;
					break;
				default:
				$cost = $server_output->data->expressDeliveryAndTaxCost;
					break;
			}
		}

		// $cost += self::INSURANCE;
		// $cost += self::SERVICE;
		// $cost += $cost * self::TAX / 100;
		$cost += $cost * $this->extra_cost_percent / 100;
		$cost += $this->extra_cost;
		
		$this->add_rate_cost( MBGHI()->convert_currency( $cost ), $package );
		return;
	}
}
