<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

define( 'SMDFW_DIR', plugin_dir_path( __FILE__ ) );

function smdfw_is_woocommerce_activated() {
	return class_exists( 'woocommerce' );
}


add_action( 'wp_loaded', 'smdfw_init', 100 );
function smdfw_init() {
	if ( ! smdfw_is_woocommerce_activated() ) {
		return;
	}
	$shipping_methods = WC()->shipping->get_shipping_methods();
	foreach ( $shipping_methods as $id => $shipping_method ) {
		add_filter( "woocommerce_shipping_instance_form_fields_$id", 'smdfw_add_form_fields' );
	}
	if ( function_exists( 'pll_current_language' ) ) {
		require_once SMDFW_DIR . 'includes/smdfw-polylang.php';
	}
	if ( function_exists( 'icl_object_id' ) && ! function_exists( 'pll_current_language' ) ) {
		require_once SMDFW_DIR . 'includes/smdfw-wpml.php';
	}
}

add_action( 'admin_notices', 'smdfw_requirement_notice' );
function smdfw_requirement_notice() {
	if ( ! smdfw_is_woocommerce_activated() ) {
		$error   = sprintf( __( 'WooCommerce Shipping Method Description requires %1$sWooCommerce%2$s to be installed and active.', 'smdfw' ), '<a href="http://wordpress.org/extend/plugins/woocommerce/">', '</a>' );
		$message = '<div class="error"><p>' . $error . '</p></div>';
		echo $message;
	}
}

function smdfw_add_form_fields( $fields ) {
	$new_fields = array(
		'description' => array(
			'title'   => __( 'Description', 'smdfw' ),
			'type'    => 'textarea',
			'default' => null,
		),
	);
	$keys  = array_keys( $fields );
	$index = array_search( 'title', $keys, true );
	$pos   = false === $index ? count( $fields ) : $index + 1;
	return array_merge( array_slice( $fields, 0, $pos ), $new_fields, array_slice( $fields, $pos ) );
}


add_filter( 'woocommerce_shipping_method_add_rate_args', 'smdfw_add_rate_description_arg', 10, 2 );
function smdfw_add_rate_description_arg( $args, $method ) {
	$args['meta_data']['description'] = htmlentities( $method->get_option( 'description' ) );
	return $args;
}

add_action( 'woocommerce_after_shipping_rate', 'smdfw_output_shipping_rate_description', 10 );
function smdfw_output_shipping_rate_description( $method ) {
	$meta_data = $method->get_meta_data();
	if ( array_key_exists( 'description', $meta_data ) ) {
		$description = apply_filters( 'smdfw_description_output', html_entity_decode( $meta_data['description'] ), $method );
		$html        = '<div class="shipping_method_description"><small class="smdfw">' . wp_kses( $description, wp_kses_allowed_html( 'post' ) ) . '</small></div>';
		echo apply_filters( 'smdfw_description_output_html', $html, $description, $method );
	}
}
