<?php
defined( 'ABSPATH' ) || exit;

class MBGHI_Product {

	public static function get_weight( WC_Product $product ): float {

		if ( $product->is_virtual() ) {
			$weight = 0;
		} else if ( $product->has_weight() ) {
			$weight = wc_get_weight( $product->get_weight(), 'g' );
		} else {
			$weight = MBGHI()->get_option( 'sadr.product_weight', 500 );
		}

		return floatval( apply_filters( 'MBGHI_product_weight', $weight, $product ) );
	}

}

remove_action( 'wp', 'wss_update_product_quantity' );
// add_action( 'wp', 'wss_update_product_quantity' );
function wss_update_product_quantity() {
    return;
    if (  is_product() ) {
        return;
    }

	$mb_options = get_option( 'MBGHI_sadr' );
    if ( ! isset( $mb_options['calc_product_qty'] ) || ! $mb_options['calc_product_qty'] ) {
        return;
    }

    $base_url = 'https://sadrcod.com:5001';
    if ( isset( $mb_options['ow_base_url'] ) && $mb_options['ow_base_url'] ) {
        $base_url = sanitize_url( $mb_options['ow_base_url'] );
    }

    $product_id = get_the_ID();
    $product = wc_get_product( $product_id );

	if ( intval( $product->get_sku() ) ) {

        $response = wp_remote_get( "{$base_url}/api/internalwarehouse/inventoryData?code=" . intval( $product->get_sku() ), array (
            'headers' => [
				"X-ATJ-Username" => $mb_options['ow_username'],
				"X-ATJ-Auth-Token" => $mb_options['ow_api_token'],
            ],
        ) );

        if ( ! is_wp_error( $response ) && $response['response']['code'] == 401 ) {
            if ( ! empty( $mb_options['ow_username'] ) && ! empty( $mb_options['ow_password'] ) ) {
                $server_output = wp_remote_post( "{$base_url}/api/security/token/new", array(
                    'headers'     => [
                        'Content-Type' => 'application/json',
                    ],
                    'body' => wp_json_encode( array(
                        'username' => $mb_options['ow_username'],
                        'password' => $mb_options['ow_password'],
                    ) ),
                ) );

                if ( !is_wp_error($server_output) && $server_output['response']['code'] == 200 ) {
                    if ( array_key_exists( 'ow_api_token', $mb_options ) ) {
                        unset($mb_options['ow_api_token']);
                    }

                    $server_output = json_decode( $server_output['body'] );
                    $mb_options['ow_api_token'] = $server_output->token;
                    update_option('MBGHI_sadr', $mb_options);

                    $response = wp_remote_get( "{$base_url}/api/internalwarehouse/inventoryData?code=" . intval( $product->get_sku() ), array (
                        'headers' => [
                            "X-ATJ-Username" => $mb_options['ow_username'],
                            "X-ATJ-Auth-Token" => $mb_options['ow_api_token'],
                        ],
                    ) );
                }
            }
        }

        if ( ! is_wp_error( $response ) && $response['response']['code'] == 200 ) {

            $server_output = json_decode( $response['body'] );

            if ( ! empty( $server_output ) ) {

                // Change product type to variable if it's simple
                if ( $product->is_type( 'simple' ) ) {
                    wp_remove_object_terms( $product_id, 'simple', 'product_type' );
                    wp_set_object_terms( $product_id, 'variable', 'product_type', false );
                }

                $product = wc_get_product( $product_id );

                if ( empty( $product->get_attribute( 'szd' ) ) ) {
                    $slug = 'szd';

                    // Generate values for the attribute
                    $taxonomy_name = wc_attribute_taxonomy_name( $slug );
                    $attribute_id = wc_attribute_taxonomy_id_by_name( $slug );

                    $attribute = new WC_Product_Attribute();
                    $attribute->set_id( 0 );
                    $attribute->set_visible( true );
                    $attribute->set_variation( true );


                    $attribute->set_id( $attribute_id );
                    $attribute->set_name( $taxonomy_name );
                    $attribute->set_options( array_map( function ( $srv ) {
                        return sanitize_text_field( $srv->property ) ;
                    }, $server_output ) );

                    // Add the attribute to the product
                    $product->set_props( array(
                        'attributes'    =>  array( $attribute ),
                    ) );
                    $product->save();

                    // Generate each variation
                    foreach ( $server_output as $srv ) {
                        $replacements = [
                            'ي' => 'ی',
                            'ك' => 'ک'
                        ];

                        $prop = sanitize_title( $srv->property );
                        $prop = str_replace( array_keys( $replacements ), array_values( $replacements ), $prop );
                        $prop = str_replace( ' ', '', $prop );

                        $variation = new WC_Product_Variation();
                        $variation->set_parent_id( $product_id );
                        $variation->set_attributes( array(
                            'pa_szd' => $prop,
                        ) );

                        $variation->set_manage_stock( true );

                        if (intval($srv->inventory) <= 0) {
                            $variation->set_stock_quantity( 0 );
                        } else {
                            $variation->set_stock_quantity( $srv->inventory );
                        }

                        $variation->update_meta_data( '_productTypeId', $srv->productTypeId );
                        $variation->set_regular_price( (int) $srv->price );
                        $variation->save();
                    }
                } else {
                    $prcVar = explode( '(', $server_output[0]->property );
                    $prcVar = $prcVar[0];
                    $attr = $product->get_available_variations( $prcVar );

                    $replacements = [
                        'ي' => 'ی',
                        'ك' => 'ک'
                    ];

                    foreach ( $attr as $att ) {
                        $att = json_decode($att);
                        $variation = new WC_Product_Variation($att->id);

                        foreach ($server_output as $srv) {

                            $var_szd = $variation->get_attribute( 'szd' );
                            $var_szd = str_replace( array_keys( $replacements ), array_values( $replacements ), $var_szd );
                            $var_szd = str_replace( ' ', '', $var_szd );

                            $prop = $srv->property;
                            $prop = str_replace( array_keys( $replacements ), array_values( $replacements ), $prop );
                            $prop = str_replace( ' ', '', $prop );

                            if ( $var_szd == $prop ) {
                                if (intval($srv->inventory) <= 0) {
                                    $variation->set_stock_quantity( 0 );
                                } else {
                                    $variation->set_stock_quantity( $srv->inventory );
                                }

                                if ( empty ($variation->get_meta( '_productTypeId' ) ) ) {
                                    $variation->update_meta_data( '_productTypeId', $srv->productTypeId );
                                }

                                $variation->set_regular_price( (int) $srv->price );
                                $variation->save();
                            }
                        }
                    }
                }
                wc_delete_product_transients( $product_id );
            }
        }
    }
}

