jQuery(document).ready(function ($) {

    let MBGHI_IDs = [];
    let MBGHI_button_submit = $("#MBGHI-tapin-submit");
    let MBGHI_button_ship = $("#MBGHI-tapin-ship");

    MBGHI_button_submit.click(function () {
        MBGHI_change_status('MBGHI-packaged');
    });

    MBGHI_button_ship.click(function () {
        MBGHI_change_status('MBGHI-ready-to-ship');
    });

    function MBGHI_change_status(status) {

        MBGHI_IDs = [];

        $('.check-column input[name="post[]"]:checked').each(function () {
            MBGHI_IDs.push($(this).val());
        });

        if (MBGHI_IDs.length === 0) {
            alert('سفارشی جهت پردازش انتخاب نشده است.');
            return false;
        }

        // Start
        MBGHI_button_submit.attr('disabled', 'disabled');
        MBGHI_button_ship.attr('disabled', 'disabled');
        $('.MBGHI-tips').remove();

        MBGHI_change_status_ajax(status);
    }

    function MBGHI_change_status_ajax(status) {

        let id = MBGHI_IDs.shift();

        if (id == undefined) {
            // End
            MBGHI_button_submit.removeAttr('disabled');
            MBGHI_button_ship.removeAttr('disabled');
            return true;
        }

        let data = {
            'action': 'MBGHI_change_order_status',
            'status': status,
            'id': id
        };

        $("tr#post-" + id + " td.order_status").html(`
                        <mark class="order-status">
                            <span>...</span>
                        </mark>
                    `);

        $.post(ajaxurl, data).then(function (response) {

            response = JSON.parse(response);

            if (response.success) {

                $("tr#post-" + id + " td.order_status").html(`
                                <mark class="order-status status-processing">
                                    <span>${response.message}</span>
                                </mark>
                            `);

            } else {

                $("tr#post-" + id + " td.order_status").html(`
                                <mark class="order-status status-MBGHI-returned">
                                    <span>خطا در پردازش</span>
                                </mark>
                            `);

                $("tr#post-" + id + " td.column-order_number").append(`
                                <mark class="order-status status-MBGHI-returned MBGHI-tips"
                                        style="margin-top: 10px; font-size: 11px;">
                                    <span>
                                        ${response.message}
                                    </span>
                                </mark>
                            `);

            }

            MBGHI_change_status_ajax(status);
        });

    }
});