jQuery(function ($) {

    function MBGHI_selectWoo(element) {
        let select2_args = {
            placeholder: element.attr('data-placeholder') || element.attr('placeholder') || '',
            width: '100%'
        };

        element.selectWoo(select2_args);
    }

    function MBGHI_state_changed(type, state_id) {

        let city_element = $('select#' + type + '_city');

        city_element.html('<option value="0">در حال بارگزاری لیست شهرها...</option>');

        let data = {
            'action': 'mahdiy_load_cities',
            'state_id': state_id,
            'type': type
        };

        $.post(MBGHI_settings.ajax_url, data, function (response) {
            city_element.html(response);
        });

        MBGHI_selectWoo(city_element);
    }

    $("select[id$='_state']").on('select2:select', function (e) {
        let type = $(this).attr('id').indexOf('billing') !== -1 ? 'billing' : 'shipping';
        let data = e.params.data;
        MBGHI_state_changed(type, data.id);
    });

    $("select[id$='_city']").on('select2:select', function (e) {
        $('body').trigger('update_checkout');
    });

    MBGHI_settings.types.forEach(type => {
        MBGHI_selectWoo($('select#' + type + '_state'));
        MBGHI_selectWoo($('select#' + type + '_city'));
    });

    let is_cod = MBGHI_settings.is_cod;

    $('form.checkout').on('change', 'input[name^="payment_method"]', function () {
        if (($(this).val() === 'cod') !== is_cod) {
            $('body').trigger('update_checkout');
            is_cod = ($(this).val() === 'cod');
        }
    });

});