<?php
defined( 'ABSPATH' ) || exit;

if ( class_exists( 'WC_Courier_Method' ) ) {
	return;
}

class WC_Courier_Method extends MBGHI_Shipping_Method {

	public $base_cost = 0;

	public $per_cost = 0;

	public function __construct( $instance_id = 0 ) {

		$this->id                 = 'WC_Courier_Method';
		$this->instance_id        = absint( $instance_id );
		$this->method_title       = __( 'پیک موتوری' );
		$this->method_description = __( 'ارسال با استفاده از پیک موتوری' );

		parent::__construct();
	}

	public function init() {

		parent::init();

		$this->base_cost = intval( $this->get_option( 'base_cost' ) );
		$this->per_cost  = intval( $this->get_option( 'per_cost' ) );

		add_action( 'woocommerce_update_options_shipping_' . $this->id, [ $this, 'process_admin_options' ] );
	}

	public function init_form_fields() {

		$currency_symbol = get_woocommerce_currency_symbol();

		$this->instance_form_fields += [
			'base_cost' => [
				'title'       => 'هزینه پایه',
				'type'        => 'price',
				'description' => 'مبلغ حمل و نقل به روش پیک موتوری را به ' . $currency_symbol . ' وارد نمائید.',
				'default'     => 0,
			],
			'per_cost'  => [
				'title'       => 'هزینه به ازای هر کیلوگرم',
				'type'        => 'price',
				'description' => 'در صورتی که قصد دارید به ازای هر کیلوگرم هزینه اضافی دریافت شود هزینه را به ' . $currency_symbol . ' وارد نمائید.',
				'default'     => 0,
				'desc_tip'    => true,
			],
		];

	}

	public function is_available( $package = [] ): bool {

		$options = MBGHI()->get_terms_option( $this->get_destination( $package ) );

		$options            = wp_list_pluck( $options, 'courier_on' );
		$this->is_available = count( array_filter( $options ) ) == count( $options );

		return parent::is_available( $package );
	}

	public function calculate_shipping( $package = [] ) {

		if ( $this->free_shipping( $package ) ) {
			return;
		}

		$cost = $this->base_cost;

		$options = MBGHI()->get_terms_option( $this->get_destination( $package ) );
		$options = array_column( $options, 'courier_cost' );

		foreach ( $options as $option ) {
			if ( $option != '' ) {
				$cost = intval( $option );
				break;
			}
		}

		$cost += ceil( $this->cart_weight / 1000 ) * $this->per_cost;

		$this->add_rate_cost( $cost, $package );
	}
}
