<?php
defined( 'ABSPATH' ) || exit;

class MBGHI_Tools {

	public function __construct() {
		if ( MBGHI()->get_option( 'tools.hide_when_free' ) == 1 ) {
			add_filter( 'woocommerce_package_rates', [ $this, 'hide_when_free' ], 100 );
		}

		if ( MBGHI()->get_option( 'tools.hide_when_courier' ) == 1 ) {
			add_filter( 'woocommerce_package_rates', [ $this, 'hide_when_courier' ], 100 );
		}

		add_filter( 'woocommerce_new_order_note_data', [ $this, 'new_order_note_data' ], 100, 2 );
		add_filter( 'MBGHI_states', [ $this, 'fix_arabic_characters' ], 1000 );
		add_filter( 'MBGHI_cities', [ $this, 'fix_arabic_characters' ], 1000 );
	}

	public function hide_when_free( array $rates ): array {
		$free = []; // snippets.ir

		foreach ( $rates as $rate_id => $rate ) {
			if ( 0 == $rate->cost ) {
				$free[ $rate_id ] = $rate;
			}
		}

		return ! empty( $free ) ? $free : $rates;
	}

	public function hide_when_courier( array $rates ): array {
		$courier = []; // snippets.ir

		foreach ( $rates as $rate_id => $rate ) {
			if ( 'WC_Courier_Method' === $rate->method_id ) {
				$courier[ $rate_id ] = $rate;
			}
		}

		return ! empty( $courier ) ? $courier : $rates;
	}

	public function new_order_note_data( $data, $args ) {

		$barcode = trim( $data['comment_content'] );

		if ( is_numeric( $barcode ) && strlen( $barcode ) >= 20 ) {
			$data['comment_content'] = "بارکد پستی مرسوله شما: {$barcode}";

			$order = new WC_Order( $args['order_id'] );
            $order->update_meta_data( 'post_barcode', $barcode );
            $order->save();

			do_action( 'MBGHI_save_order_post_barcode', $order, $barcode );
		}

		return $data;
	}

	public function fix_arabic_characters( array $list ): array {

		foreach ( $list as &$item ) {
			$item = str_replace( [ 'ك', 'ي', ], [ 'ک', 'ی' ], $item );
		}

		return $list;
	}
}

new MBGHI_Tools();
