<?php
defined( 'ABSPATH' ) || exit;

class MBGHI_Status {

	public static $status = [
		2 => 'wc-MBGHI-ready-to-ship',

		1 => 'wc-MBGHI-packaged',

		10  => 'wc-MBGHI-returned',
		11  => 'wc-MBGHI-returned',
		83  => 'wc-MBGHI-returned',
		102 => 'wc-MBGHI-returned',

		7  => 'wc-completed',
		70 => 'wc-completed',
		71 => 'wc-completed',
		72 => 'wc-completed',

		80 => 'wc-MBGHI-deleted',

		5  => 'wc-MBGHI-shipping',
		8  => 'wc-MBGHI-shipping',
		13 => 'wc-MBGHI-shipping',
		14 => 'wc-MBGHI-shipping',
		15 => 'wc-MBGHI-shipping',
		16 => 'wc-MBGHI-shipping',
		17 => 'wc-MBGHI-shipping',
		50 => 'wc-MBGHI-shipping',

		3  => 'wc-MBGHI-need-review',
		4  => 'wc-MBGHI-need-review',
		6  => 'wc-MBGHI-need-review',
		9  => 'wc-MBGHI-need-review',
		12 => 'wc-MBGHI-need-review',
		81 => 'wc-MBGHI-need-review',
		82 => 'wc-MBGHI-need-review',
		18 => 'wc-MBGHI-need-review',
	];

	public function __construct() {
		add_action( 'init', [ $this, 'register_order_statuses' ] );
		add_filter( 'wc_order_statuses', [ $this, 'add_order_statuses' ], 10, 1 );
		add_filter( 'woocommerce_reports_order_statuses', [ $this, 'reports_statuses' ], 10, 1 );
		add_filter( 'woocommerce_order_is_paid_statuses', [ $this, 'paid_statuses' ], 10, 1 );
		add_filter( 'bulk_actions-edit-shop_order', [ $this, 'bulk_actions' ], 20, 1 );

		if ( function_exists( 'is_plugin_active' ) && is_plugin_active( 'persian-woocommerce-shipping-dokan/MBGHI-dokan.php' ) ) {
			return;
		}

		add_action( 'admin_enqueue_scripts', [ $this, 'enqueue_scripts' ] );

		if ( MBGHI_Sadr::is_enable() ) {
			add_action( 'add_meta_boxes', [ $this, 'order_meta_box' ] );
			add_action( 'save_post', [ $this, 'save_order_meta_box' ], 1000, 3 );
			add_action( 'manage_posts_extra_tablenav', [ $this, 'top_order_list' ], 20, 1 );
			add_action( 'wp_ajax_MBGHI_change_order_status', [ $this, 'change_status_callback' ] );
			add_action( 'wp', [ $this, 'check_status_scheduled' ] );
			add_action( 'MBGHI_check_status', [ $this, 'check_status_callback' ] );
		}
	}

	public static function get_statues(): array {

		$statuses = [];

		if ( MBGHI()->get_option( 'tools.status_enable' ) == 1 ) {

			$statuses['wc-MBGHI-in-stock'] = __( 'ارسال شده به انبار' );
			$statuses['wc-MBGHI-packaged'] = __( 'بسته بندی شده' );
			$statuses['wc-MBGHI-courier']  = __( 'تحویل پیک' );
			$statuses['wc-MBGHI-post']     = __( 'تحویل پست' );

		}

		if ( MBGHI_Sadr::is_enable() ) {
			$statuses['wc-MBGHI-packaged']      = __( 'بسته بندی شده' );
			$statuses['wc-MBGHI-ready-to-ship'] = __( 'آماده به ارسال' );
			$statuses['wc-MBGHI-returned']      = __( 'برگشتی' );
			$statuses['wc-MBGHI-deleted']       = __( 'حذف شده' );
			$statuses['wc-MBGHI-shipping']      = __( 'در حال ارسال' );
			$statuses['wc-MBGHI-need-review']   = __( 'نیازمند بررسی' );
		}

		return apply_filters( 'MBGHI_get_order_statuses', $statuses );
	}

	public function register_order_statuses() {

		foreach ( $this->get_statues() as $status => $label ) {
			register_post_status( $status, [
				'label'                     => $label,
				'public'                    => false,
				'exclude_from_search'       => false,
				'show_in_admin_all_list'    => true,
				'show_in_admin_status_list' => true,
				'label_count'               => _n_noop( $label . ' <span class="count">(%s)</span>', $label . ' <span class="count">(%s)</span>' ),
			] );
		}

	}

	public function add_order_statuses( $order_statuses ): array {
		$new_order_statuses = [];

		foreach ( $order_statuses as $key => $status ) {
			$new_order_statuses[ $key ] = $status;

			if ( 'wc-processing' === $key ) {

				foreach ( $this->get_statues() as $status => $label ) {
					$new_order_statuses[ $status ] = $label;
				}

			}
		}

		return $new_order_statuses;
	}

	public function reports_statuses( $order_status ) {

		$dont_report = [
			'wc-MBGHI-returned',
			'wc-MBGHI-deleted',
		];

		foreach ( $this->get_statues() as $status => $label ) {
			if ( ! in_array( $status, $dont_report ) ) {
				$order_status[] = str_replace( 'wc-', '', $status );
			}
		}

		return $order_status;
	}

	public function paid_statuses( $order_status ) {

		$dont_paid = [
			'wc-MBGHI-returned',
			'wc-MBGHI-deleted',
		];

		foreach ( $this->get_statues() as $status => $label ) {
			if ( ! in_array( $status, $dont_paid ) ) {
				$order_status[] = str_replace( 'wc-', '', $status );
			}
		}

		return $order_status;
	}

	public function bulk_actions( $actions ) {

		foreach ( $this->get_statues() as $status => $label ) {
			$key                       = str_replace( 'wc-', '', $status );
			$actions[ 'mark_' . $key ] = 'تغییر وضعیت به ' . $label;
		}

		return $actions;
	}

	public function enqueue_scripts() {

		wp_enqueue_style( 'MBGHI_order_status', MBGHI_URL . 'assets/css/status.css' );

		if ( ! MBGHI_Sadr::is_enable() ) {
			return;
		}

		$screen = get_current_screen();

		if ( $screen->id == 'edit-shop_order' ) {
			wp_enqueue_script( 'MBGHI_sadr_list', MBGHI_URL . 'assets/js/sadr-list.js' );
		}

		if ( $screen->id == 'shop_order' ) {
			wp_enqueue_script( 'MBGHI_sadr_list', MBGHI_URL . 'assets/js/sadr-order.js' );
		}
	}

	public function top_order_list( $which ) {
		global $typenow;

		if ( 'shop_order' === $typenow && 'top' === $which ) {
			?>
			<div class="alignleft actions custom">
				<button type="button" id="MBGHI-sadr-submit" class="button-primary"
						title="جهت ثبت سفارشات انتخاب شده در پنل صدر و دریافت بارکد پستی، کلیک کنید.">ثبت در صدر
				</button>
				<button type="button" id="MBGHI-sadr-ship" class="button-primary"
						title="پس از ثبت سفارش در پنل، جهت اعلام به پست برای جمع آوری بسته اینجا کلیک کنید.">آماده ارسال
				</button>
			</div>
			<?php
		}
	}

	public function order_meta_box() {
		add_meta_box( 'sadr_order', 'صدر', [ $this, 'order_meta_box_callback' ], 'shop_order', 'side' );
	}

	public function order_meta_box_callback( $post, $args ) {

		$order = wc_get_order( $post->ID );

		$order_uuid   = $order->get_meta( 'sadr_order_uuid' );
		$sadr_weight = MBGHI_Order::get_weight( $order );

		$content_type = $order->get_meta( 'sadr_content_type' );

		if ( empty( $content_type ) ) {
			$content_type = MBGHI()->get_option( 'sadr.content_type', 4 );
		}

		$shipping_method = MBGHI_Order::get_shipping_method( $order )

		?>

		<?php if ( empty( $order_uuid ) ) { ?>

			<p class="form-field-wide">
				<label for="sadr_weight">وزن سفارش:</label>
				<input type="number" name="sadr_weight" id="sadr_weight" style="width: 100%"
					   value="<?php echo intval( $sadr_weight ); ?>">
			</p>

			<p class="form-field-wide">
				<label>نوع مرسوله:</label>
				<select style="width: 100%" name="sadr_content_type" id="sadr_content_type">
					<option value="1" <?php selected( 1, $content_type ); ?>>عادی</option>
					<option value="2" <?php selected( 2, $content_type ); ?>>شکستنی</option>
					<option value="3" <?php selected( 3, $content_type ); ?>>مایعات</option>
					<option value="4" <?php selected( 4, $content_type ); ?>>غیراستاندارد</option>
				</select>
			</p>

			<button type="button" id="MBGHI-sadr-submit" class="button-primary"
					title="جهت ثبت سفارشات انتخاب شده در پنل صدر و دریافت بارکد پستی، کلیک کنید.">ثبت در صدر
			</button>
		<?php } else { ?>

			<p class="form-field-wide">
				<label>وزن سفارش:</label>
				<input type="number" style="width: 100%"
					   value="<?php echo intval( $sadr_weight ); ?>" disabled="disabled">
			</p>

			<p class="form-field-wide">
				<label>نوع پست:</label>
				<select style="width: 100%" disabled="disabled">
					<option value="" <?php selected( null, $shipping_method ); ?>>غیرپستی</option>
					<option value="0" <?php selected( 0, $shipping_method ); ?>>پست سفارشی</option>
					<option value="1" <?php selected( 1, $shipping_method ); ?>>پست پیشتاز</option>
				</select>
			</p>

			<p class="form-field-wide">
				<label>نوع مرسوله:</label>
				<select style="width: 100%" disabled="disabled">
					<option value="1" <?php selected( 1, $content_type ); ?>>عادی</option>
					<option value="2" <?php selected( 2, $content_type ); ?>>شکستنی</option>
					<option value="3" <?php selected( 3, $content_type ); ?>>مایعات</option>
					<option value="4" <?php selected( 4, $content_type ); ?>>غیراستاندارد</option>
				</select>
			</p>

			<button type="button" id="MBGHI-sadr-ship" class="button-primary"
					title="پس از ثبت سفارش در پنل، جهت اعلام به پست برای جمع آوری بسته اینجا کلیک کنید.">آماده ارسال
			</button>
			<?php
		}

		?>
		<div class="MBGHI-tips" style="margin-top: 15px;"></div>
		<?php
	}

	public function save_order_meta_box( $order_id, $post, $update ) {

        $order = wc_get_order( $order_id );
        $order_uuid = $order->get_meta( 'sadr_order_uuid', true );

		if ( ! empty( $order_uuid ) ) {
			return;
		}

		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
			return;
		}

		if ( get_post_status( $order_id ) === 'auto-draft' ) {
			return;
		}

		if ( ! isset( $_POST['sadr_weight'], $_POST['sadr_content_type'] ) ) {
			return;
		}

        $order->update_meta_data( 'sadr_weight', floatval( $_POST['sadr_weight'] ) );
        $order->update_meta_data( 'sadr_content_type', intval( $_POST['sadr_content_type'] ) );
        $order->save();
	}

	public function change_status_callback() {

		if ( ! current_user_can( 'edit_shop_orders' ) ) {
			wp_die( - 1 );
		}

		$status = sanitize_text_field( $_POST['status'] ?? null );

		if ( ! wc_is_order_status( 'wc-' . $status ) ) {

			echo json_encode( [
				'success' => false,
				'message' => 'وضعیت انتخاب شده معتبر نمی باشد.',
			] );

			die();
		}

		$order_id = intval( $_POST['id'] ?? null );

		if ( empty( $order_id ) ) {

			echo json_encode( [
				'success' => false,
				'message' => 'سفارش انتخاب شده معتبر نمی باشد.',
			] );

			die();
		}

		$order = wc_get_order( $order_id );

		if ( $order == false ) {

			echo json_encode( [
				'success' => false,
				'message' => 'سفارش انتخاب شده وجود ندارد.',
			] );

			die();
		}

		if ( isset( $_POST['weight'] ) ) {
			$order->add_meta_data( 'sadr_weight', floatval( $_POST['weight'] ), true );
			$order->save_meta_data();
		}

		if ( isset( $_POST['content_type'] ) ) {
			$order->add_meta_data( 'sadr_content_type', intval( $_POST['content_type'] ), true );
			$order->save_meta_data();
		}

		$sadr_post_type = MBGHI_Order::get_shipping_method( $order );

		if ( is_null( $sadr_post_type ) ) {

			echo json_encode( [
				'success' => false,
				'message' => 'روش ارسال این سفارش صدر نیست.',
			] );

			die();
		}

		$sadr_order_uuid = $order->get_meta( 'sadr_order_uuid', true );

		if ( $status == 'MBGHI-packaged' ) { // Submit & get post barcode

			if ( ! empty( $sadr_order_uuid ) ) {

				echo json_encode( [
					'success' => false,
					'message' => 'این سفارش قبلا در پنل ثبت شده است.',
				] );

				die();
			}

			$products = [];

			foreach ( $order->get_items() as $order_item ) {

				$product = $order_item->get_product();

				if ( $product && $product->is_virtual() ) {
					continue;
				}

				$price = ( $order_item->get_total() + $order_item->get_total_tax() ) / $order_item->get_quantity();
				$price = ceil( $price );

				if ( get_woocommerce_currency() == 'IRT' ) {
					$price *= 10;
				}

				if ( get_woocommerce_currency() == 'IRHR' ) {
					$price *= 1000;
				}

				if ( get_woocommerce_currency() == 'IRHT' ) {
					$price *= 10000;
				}

				$title = trim( MBGHI()->get_option( 'sadr.product_title' ) );

				if ( empty( $title ) ) {
					$title = $order_item->get_name();
				}

				if ( function_exists( 'mb_substr' ) ) {
					$title = mb_substr( $title, 0, 50 );
				}

				$products[] = [
					'count'      => $order_item->get_quantity(),
					'discount'   => 0,
					'price'      => intval( $price ),
					'title'      => $title,
					'weight'     => 0,
					'product_id' => null,
				];
			}

			$order_weight = MBGHI_Order::get_weight( $order );

			$sadr_content_type = $order->get_meta( 'sadr_content_type' );

			if ( empty( $sadr_content_type ) ) {
				$sadr_content_type = MBGHI()->get_option( 'sadr.content_type', 4 );
			}

			$sadr_pay_type = 1;

			if ( $order->get_payment_method() == 'cod' ) {

				if ( $order->get_shipping_total() ) {
					$sadr_pay_type = 0;

					$packaging_cost = $order->get_meta( 'packaging_cost' );

					if ( $packaging_cost ) {

						if ( $packaging_cost == $order->get_shipping_total() ) {
							$sadr_pay_type = 3;
						}

						if ( get_woocommerce_currency() == 'IRT' ) {
							$packaging_cost *= 10;
						}

						if ( get_woocommerce_currency() == 'IRHR' ) {
							$packaging_cost *= 1000;
						}

						if ( get_woocommerce_currency() == 'IRHT' ) {
							$packaging_cost *= 10000;
						}

						$products[] = [
							'count'      => 1,
							'discount'   => 0,
							'price'      => intval( $packaging_cost ),
							'title'      => 'بسته بندی',
							'weight'     => 0,
							'product_id' => null,
						];
					}

				} else {
					$sadr_pay_type = 3;
				}

			}

			if ( wc_ship_to_billing_address_only() ) {
				$address       = $order->get_billing_address_1() . ' ' . $order->get_billing_address_2();
				$city_code     = $order->get_meta( '_billing_city_id' );
				$province_code = $order->get_meta( '_billing_state_id' );
				$first_name    = $order->get_billing_first_name();
				$last_name     = $order->get_billing_last_name();
				$postcode      = $order->get_billing_postcode();
			} else {
				$address       = $order->get_shipping_address_1() . ' ' . $order->get_shipping_address_2();
				$city_code     = $order->get_meta( '_shipping_city_id' );
				$province_code = $order->get_meta( '_shipping_state_id' );
				$first_name    = $order->get_shipping_first_name();
				$last_name     = $order->get_shipping_last_name();
				$postcode      = $order->get_shipping_postcode();
			}

			$data = apply_filters( 'MBGHI_sadr_submit_order', [
				'register_type'  => 1,
				'shop_id'        => MBGHI()->get_option( 'sadr.shop_id' ),
				'address'        => $address,
				'city_code'      => $city_code,
				'province_code'  => $province_code,
				'description'    => empty( $order->get_customer_note() ) ? null : $order->get_customer_note(),
				'email'          => null,
				'employee_code'  => '-1',
				'first_name'     => $first_name,
				'last_name'      => $last_name,
				'mobile'         => str_replace( [ '+98', '0098' ], '0', $order->get_billing_phone() ),
				'phone'          => null,
				'postal_code'    => $postcode,
				'pay_type'       => $sadr_pay_type,
				'order_type'     => $sadr_post_type,
				'content_type'   => $sadr_content_type,
				'package_weight' => $order_weight,
				'products'       => $products,
				'manual_id'      => $order_id,
			], $order );

			$data['presenter_code'] = 1025;

            $mbghi_sadr = new MBGHI_Sadr();
			$mbghi_sadr->set_gateway( MBGHI()->get_option( 'sadr.gateway' ) );

			$response = $mbghi_sadr->request( 'v2/public/order/post/register', $data );

			if ( is_wp_error( $response ) ) {

				echo json_encode( [
					'success' => false,
					'message' => implode( '<br>', $response->get_error_messages() ),
				] );

				die();

			} else if ( ! in_array( $response->returns->status, [ 200, 770 ] ) ) {

				$errors = [];

				foreach ( (array) $response->entries as $key => $message ) {
					if ( is_string( $message[0] ) ) {
						$errors[] = "{$key} > {$message[0]}";
					}
				}

				echo json_encode( [
					'success' => false,
					'message' => $response->returns->message . '<br>' . implode( '<br>', $errors ),
				] );

				die();
			}

			$order->update_meta_data( 'sadr_order_uuid', $response->entries->id );
			$order->update_meta_data( 'sadr_order_id', $response->entries->order_id );
			$order->update_meta_data( 'sadr_send_price', $response->entries->send_price );
			$order->update_meta_data( 'sadr_send_price_tax', $response->entries->send_price_tax );
			$order->update_meta_data( 'sadr_send_time', time() );
			$order->update_meta_data( 'sadr_weight', $order_weight );
			$order->update_meta_data( 'sadr_content_type', $sadr_content_type );
			$order->update_meta_data( 'post_barcode', $response->entries->barcode );

			$note = "بارکد پستی مرسوله شما: {$response->entries->barcode}
                        می توانید مرسوله خود را از طریق لینک https://radgir.net رهگیری نمایید.";

			$order->set_status( $status, 'صدر -' );
			$order->save();
			$order->add_order_note( $note, 1 );

			do_action( 'MBGHI_save_order_post_barcode', $order, $response->entries->barcode );

			echo json_encode( [
				'success' => true,
				'message' => 'بسته بندی شده',
			] );

			die();

		} else if ( $status == 'MBGHI-ready-to-ship' ) {

			if ( empty( $sadr_order_uuid ) ) {

				echo json_encode( [
					'success' => false,
					'message' => 'سفارش در صدر ثبت نشده است.',
				] );

				die();
			}

			$sadr_order_id = $order->get_meta( 'sadr_order_id', true );

			$data = [
				'shop_id'  => MBGHI()->get_option( 'sadr.shop_id' ),
				'order_id' => $sadr_order_id,
				'status'   => 2,
			];

            $mbghi_sadr = new MBGHI_Sadr();
			$mbghi_sadr->set_gateway( MBGHI()->get_option( 'sadr.gateway' ) );

			$response = $mbghi_sadr->request( 'v2/public/order/post/change-status', $data );

			if ( is_wp_error( $response ) ) {

				echo json_encode( [
					'success' => false,
					'message' => implode( '<br>', $response->get_error_messages() ),
				] );

				die();

			} else if ( $response->returns->status != 200 ) {

				$errors = [];

				foreach ( (array) $response->entries as $key => $message ) {
					if ( is_string( $message[0] ) ) {
						$errors[] = "{$key} > {$message[0]}";
					}
				}

				echo json_encode( [
					'success' => false,
					'message' => $response->returns->message . '<br>' . implode( '<br>', $errors ),
				] );

				die();
			}

			$order->set_status( $status, 'صدر -' );
			$order->save();

			echo json_encode( [
				'success' => true,
				'message' => 'آماده به ارسال',
			] );

			die();

		} else {

			echo json_encode( [
				'success' => false,
				'message' => "ابتدا باید به 'بسته بندی شده' تغییر وضعیت دهید.",
			] );

			die();

		}

	}

	public function check_status_scheduled() {
		if ( ! wp_next_scheduled( 'MBGHI_check_status' ) ) {
			wp_schedule_event( time(), 'hourly', 'MBGHI_check_status' );
		}
	}

	public static function check_status_callback() {

		$args_query = apply_filters( 'MBGHI_sadr_check_status_orders', [
			'post_type'      => [ 'shop_order' ],
			'post_status'    => [
				'wc-MBGHI-packaged',
				'wc-MBGHI-ready-to-ship',
				'wc-MBGHI-shipping',
				'wc-MBGHI-deleted',
				'wc-MBGHI-need-review',
			],
			'posts_per_page' => 100,
			'orderby'        => 'rand',
			'meta_key'       => 'sadr_order_uuid',
		] );

		$query = new WP_Query( $args_query );

		$posts = array_column( $query->posts, 'ID' );

		$posts = array_map( function ( $post_id ) {
			return [
				'id'      => get_post_meta( $post_id, 'sadr_order_uuid', true ),
				'post_id' => $post_id,
			];
		}, $posts );
		$posts = array_filter( $posts, function ( $row ) {
			return ! empty( $row['id'] );
		} );

		if ( count( $posts ) == 0 ) {
			return false;
		}

        $mbghi_sadr = new MBGHI_Sadr();
		$mbghi_sadr->set_gateway( MBGHI()->get_option( 'sadr.gateway' ) );

		$statuses = $mbghi_sadr->request( 'v2/public/order/post/get-status/bulk', [
			'shop_id' => MBGHI()->get_option( 'sadr.shop_id' ),
			'orders'  => array_values( $posts ),
		] );

		if ( is_wp_error( $statuses ) || ! isset( $statuses->entries->list ) || ! is_array( $statuses->entries->list ) ) {
			return false;
		}

		$orders = array_column( $statuses->entries->list, null, 'id' );

		foreach ( $posts as $post ) {

			if ( ! isset( $orders[ $post['id'] ] ) ) {
				continue;
			}

			$status = $orders[ $post['id'] ]->status;

			$status = self::$status[ $status ] ?? null;

			if ( is_null( $status ) ) {
				continue;
			}

			$order = wc_get_order( $post['post_id'] );

			if ( $order->get_status() != $status ) {
				$order->set_status( $status, 'بروزرسانی خودکار صدر -' );
				$order->save();
			}

		}

		wp_reset_postdata();
	}

}

new MBGHI_Status();
