<?php
defined( 'ABSPATH' ) || exit;

class MBGHI_Sadr extends MBGHI_Core {

	protected $gateway = 'sadr';

    protected $gateways;


	public static function instance() {

		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}

		return self::$_instance;
	}

	public function __construct() {

        $this->gateways = [];

		$mb_options = get_option('MBGHI_sadr');
        $base_url = 'https://sadrcod.com:5001';
        if ( isset( $mb_options['ow_base_url'] ) && $mb_options['ow_base_url'] ) {
            $base_url = sanitize_url( $mb_options['ow_base_url'] );
        }
        $this->gateways = [
            'sadr' => "{$base_url}",
            'token' => "{$base_url}/api/security/token/new",
            'cost' => "{$base_url}/ws/v006/getDeliveryCostV2",
            'register' => "{$base_url}/ws/v006/registerPackageV3SadrOnly",
            'quanity' => "{$base_url}/api/internalwarehouse/inventoryData?code="
        ];

        self::$methods = [
            'WC_Courier_Method',
			'Sadr_Sefareshi_Method',
		];

		add_filter( 'get_ancestors', function ( $ancestors, $object_id, $object_type, $resource_type ) {

			if ( $object_type == 'state_city' ) {

				$ancestors = wp_cache_get( 'city_ancestors', 'MBGHI' );

				if ( $ancestors !== false ) {
					return $ancestors;
				}

				$ancestors = [];

				$zone = wp_list_pluck( MBGHI()::zone(), 'cities', null );

				foreach ( $zone as $state_id => $cities ) {
					if ( isset( $cities[ $object_id ] ) ) {
						$ancestors = [ 'state_' . $state_id ];
						break;
					}
				}

				wp_cache_set( 'city_ancestors', $ancestors, 'MBGHI' );

				return $ancestors;
			}

			return $ancestors;
		}, 10, 4 );

		parent::init_hooks();
	}

	public function enqueue_select2_scripts() {
		if ( ! is_checkout() ) {
			return false;
		}

		wp_register_script( 'selectWoo', WC()->plugin_url() . '/assets/js/selectWoo/selectWoo.full.min.js', [ 'jquery' ], '4.0.3' );
		wp_enqueue_script( 'selectWoo' );
		wp_register_style( 'select2', WC()->plugin_url() . '/assets/css/select2.css' );
		wp_enqueue_style( 'select2' );

		wp_register_script( 'MBGHICheckout', MBGHI_URL . 'assets/js/MBGHI-sadr.js', [ 'selectWoo' ], '1.0.0' );
		wp_localize_script( 'MBGHICheckout', 'MBGHI_settings', [
			'ajax_url' => admin_url( 'admin-ajax.php' ),
			'types'    => $this->types(),
			'is_cod'   => WC()->session->get( 'chosen_payment_method' ) == 'cod',
		] );
		wp_enqueue_script( 'MBGHICheckout' );
	}

	public function checkout_update_order_meta( $order_id ) {

		$types  = $this->types();
		$fields = [ 'state', 'city' ];

		$order = wc_get_order( $order_id );

		foreach ( $types as $type ) {

			foreach ( $fields as $field ) {

				$term_id = $order->get_meta( "_{$type}_{$field}", true );
				$term    = self::{'get_' . $field}( intval( $term_id ) );

				if ( ! is_null( $term ) ) {
					$order->update_meta_data( "_{$type}_{$field}", $term );
					$order->update_meta_data( "_{$type}_{$field}_id", $term_id );
				}

			}
		}

		if ( wc_ship_to_billing_address_only() ) {

			foreach ( $fields as $field ) {

				$label = $order->get_meta( "_billing_{$field}", true );
				$id    = $order->get_meta( "_billing_{$field}_id", true );

				$order->update_meta_data( "_shipping_{$field}", $label );
				$order->update_meta_data( "_shipping_{$field}_id", $id );
			}

		}


		foreach ( $order->get_shipping_methods() as $shipping_item ) {

			if ( in_array( $shipping_item->get_method_id(), [ 'Sadr_Pishtaz_Method', 'Sadr_Sefareshi_Method' ] ) ) {

				$instance_id = $shipping_item->get_instance_id();

				$data = get_option( "woocommerce_{$shipping_item->get_method_id()}_{$instance_id}_settings" );

				$packaging_cost = intval( $data['extra_cost'] ?? 0 );

				if ( $shipping_item->get_total() && $packaging_cost ) {
					$order->update_meta_data( 'packaging_cost', $packaging_cost );
				}
			}
		}

        $order->save();
	}

	public function checkout_process() {

		$types = $this->types();

		$fields = [
			'state' => 'استان',
			'city'  => 'شهر',
		];

		$type_label = [
			'billing'  => 'صورتحساب',
			'shipping' => 'حمل و نقل',
		];

		if ( ! isset( $_POST['ship_to_different_address'] ) && count( $types ) == 2 ) {
			unset( $types[1] );
		}

		foreach ( $types as $type ) {

			$label = $type_label[ $type ];

			foreach ( $fields as $field => $name ) {

				$key = $type . '_' . $field;

				if ( isset( $_POST[ $key ] ) && strlen( $_POST[ $key ] ) ) {

					$value = intval( $_POST[ $key ] );

					if ( $value == 0 ) {
						$message = sprintf( 'لطفا <b>%s %s</b> خود را انتخاب نمایید.', $name, $label );
						wc_add_notice( $message, 'error' );

						continue;
					}

					$invalid = is_null( self::{'get_' . $field}( $value ) );

					if ( $invalid ) {
						$message = sprintf( '<b>%s %s</b> انتخاب شده معتبر نمی باشد.', $name, $label );
						wc_add_notice( $message, 'error' );

						continue;
					}

					if ( $field == 'state' ) {

						$pkey = $type . '_city';

						$cities = self::cities( $value );

						if ( isset( $_POST[ $pkey ] ) && ! empty( $_POST[ $pkey ] ) && ! isset( $cities[ $_POST[ $pkey ] ] ) ) {
							$message = sprintf( '<b>استان</b> با <b>شهر</b> %s انتخاب شده همخوانی ندارند.', $label );
							wc_add_notice( $message, 'error' );

							continue;
						}
					}

				}

			}

		}
	}

	public function cart_shipping_packages( $packages ) {

		for ( $i = 0; $i < count( $packages ); $i ++ ) {
			$packages[ $i ]['destination']['is_cod'] = WC()->session->get( 'chosen_payment_method' ) == 'cod';
		}

		return $packages;
	}

	public function localisation_address_formats( $formats ) {

		$formats['IR'] = "{company}\n{first_name} {last_name}\n{country}\n{state}\n{city}\n{address_1}\n{address_2}\n{postcode}";

		return $formats;
	}

	public function formatted_address_replacements( $replace, $args ) {

		$replace = parent::formatted_address_replacements( $replace, $args );

		if ( ctype_digit( $args['city'] ) ) {
			$city              = $this->get_city( $args['city'] );
			$replace['{city}'] = is_null( $city ) ? $args['city'] : $city;
		}

		return $replace;
	}

	public static function is_enable(): bool {
		//return self::get_option( 'sadr.enable', false ) == 1;
		return 0;
	}

	public function request( $path, $data = [], $absolute_url = null ) {
		$path = trim( $path, ' / ' );
		$url = sprintf( '%s/%s', $this->gateways[ $this->gateway ], $path );

		if ( ! is_null( $absolute_url ) ) {
			$url = $absolute_url;
		}

		$mb_options = get_option('MBGHI_sadr');
		if (!empty($mb_options['ow_api_token'])) {
			$sdr_token = $mb_options['ow_api_token'];
		}

		$curl = curl_init();

		curl_setopt_array( $curl, [
			CURLOPT_URL            => $url,
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING       => "",
			CURLOPT_MAXREDIRS      => 1,
			CURLOPT_TIMEOUT        => 10,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION   => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST  => "POST",
			CURLOPT_POSTFIELDS     => json_encode( $data ),
			CURLOPT_HTTPHEADER     => [
				"Content-type: application/json",
				"Accept: application/json",
				//"Authorization: " . $sdr_token,
			],
		] );

		$response  = curl_exec( $curl );
		$http_code = curl_getinfo( $curl, CURLINFO_HTTP_CODE );
		$error     = curl_error( $curl );

		if ( $response === false || $error ) {
			curl_close( $curl );

			return new WP_Error( '', $error );
		}

		if ( $http_code >= 300 ) {
			return new WP_Error( $http_code, "خطا {$http_code}" );
		}

		curl_close( $curl );

		return json_decode( $response );
	}

	public function get_term_option( $term_id ): array {
		$option = get_option( 'nabik_taxonomy_sadr_' . $term_id, [] );
		return apply_filters( 'MBGHI_get_term_option', $option, $term_id );
	}

	public function set_term_option( $term_id, array $option ) {
		$option = apply_filters( 'MBGHI_set_term_option', $option, $term_id );
		update_option( 'nabik_taxonomy_sadr_' . $term_id, $option );
	}

	public function delete_term_option( $term_id ) {
		delete_option( 'nabik_taxonomy_sadr_' . $term_id );
	}

	public function shop() {
		if ( empty( MBGHI()->get_option( 'sadr.shop_id' ) ) ) {
			return new stdClass();
		}

		$shop = get_transient( 'MBGHI_sadr_shop' );

		if ( $shop === false || count( (array) $shop ) == 0 ) {
			$this->set_gateway( MBGHI()->get_option( 'sadr.gateway' ) );
			$shop = $this->request( 'v2/public/shop/detail', [
				'shop_id' => MBGHI()->get_option( 'sadr.shop_id' ),
			] );
			if ( is_wp_error( $shop ) ) {
				return get_option( 'MBGHI_sadr_shop', [] );
			} else {
				$shop = $shop->entries;
			}
			set_transient( 'MBGHI_sadr_shop', $shop, DAY_IN_SECONDS );
			update_option( 'MBGHI_sadr_shop', $shop );
		}

		return $shop;
	}

	public function set_gateway( string $gateway ) {
		if ( in_array( $gateway, array_keys( $this->gateways ) ) ) {
			$this->gateway = $gateway;
		}
	}

}

