<?php
defined( 'ABSPATH' ) || exit;

class MBGHI_Core {

	public static $methods = [];
	protected static $_instance = null;
    private static $barcode;
	public static function instance() {

		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}

		return self::$_instance;
	}

	public function __construct() {

		self::$methods = [
			'WC_Courier_Method',
			'WC_Custom_Method',
			'WC_Forehand_Method',
		];

		$this->init_hooks();
	}

	protected function init_hooks() {

		$this->state_city_taxonomy();

		// Actions
		add_action( 'wp_ajax_mahdiy_load_cities', [ MBGHI_Ajax::class, 'load_cities_callback' ] );
		add_action( 'wp_ajax_nopriv_mahdiy_load_cities', [ MBGHI_Ajax::class, 'load_cities_callback' ] );
		add_action( 'wp_ajax_mahdiy_load_districts', [ MBGHI_Ajax::class, 'load_districts_callback' ] );
		add_action( 'wp_ajax_nopriv_mahdiy_load_districts', [ MBGHI_Ajax::class, 'load_districts_callback' ] );
		add_action( 'woocommerce_shipping_init', [ $this, 'load_shipping_init' ] );
		add_action( 'woocommerce_checkout_update_order_review', [ $this, 'checkout_update_order_review' ], 10, 1 );
		add_action( 'woocommerce_admin_field_MBGHI_single_country', [ $this, 'MBGHI_single_country_field' ], 10, 1 );
		add_action( 'wp_enqueue_scripts', [ $this, 'enqueue_select2_scripts' ], 1000 );

		// Filters
		add_filter( 'woocommerce_shipping_methods', [ $this, 'add_shipping_method' ] );
		add_filter( 'woocommerce_get_settings_general', [ $this, 'get_settings_general' ], 10, 1 );
		add_filter( 'woocommerce_states', [ $this, 'iran_states' ], 20, 1 );
		add_filter( 'manage_edit-state_city_columns', [ $this, 'edit_state_city_columns_taxonomy' ], 10, 1 );
		add_filter( 'manage_state_city_custom_column', [ $this, 'edit_state_city_rows_taxonomy' ], 10, 3 );
		add_filter( 'woocommerce_checkout_fields', [ $this, 'edit_checkout_cities_field' ], 20, 1 );
		add_filter( 'woocommerce_checkout_update_order_meta', [ $this, 'checkout_update_order_meta' ], 20, 1 );
		add_filter( 'woocommerce_checkout_process', [ $this, 'checkout_process' ], 20, 1 );
		add_filter( 'woocommerce_form_field_billing_city', [ $this, 'checkout_cities_field' ], 11, 4 );
		add_filter( 'woocommerce_form_field_shipping_city', [ $this, 'checkout_cities_field' ], 11, 4 );
		add_filter( 'woocommerce_form_field_billing_district', [ $this, 'checkout_cities_field' ], 11, 4 );
		add_filter( 'woocommerce_form_field_shipping_district', [ $this, 'checkout_cities_field' ], 11, 4 );
		add_filter( 'woocommerce_cart_shipping_packages', [ $this, 'cart_shipping_packages' ], 20, 1 );
		add_filter( 'woocommerce_cart_shipping_method_full_label', [ $this, 'shipping_method_image' ], 100, 2 );
		add_filter( 'woocommerce_localisation_address_formats', [ $this, 'localisation_address_formats' ], 20, 1 );
		add_filter( 'woocommerce_order_formatted_shipping_address', [
			$this,
			'order_formatted_shipping_address',
		], 20, 2 );
		add_filter( 'woocommerce_order_formatted_billing_address', [
			$this,
			'order_formatted_billing_address',
		], 00, 2 );
		add_filter( 'woocommerce_formatted_address_replacements', [
			$this,
			'formatted_address_replacements',
		], 10, 2 );
		add_filter( 'woocommerce_my_account_my_address_formatted_address', [
			$this,
			'my_account_my_address_formatted_address',
		], 10, 3 );
		add_filter( 'woocommerce_checkout_get_value', [ $this, 'checkout_get_value' ], 10, 2 );

		add_action( 'woocommerce_before_thankyou', [ $this, 'ow_afterpayment_complete' ] );
		add_action( 'woocommerce_order_details_after_order_table_items', [ $this, 'show_barcode_table' ], 100 );
	}


    public function show_barcode_table( $order ) {
		$mb_options = get_option('MBGHI_sadr');
        if ( ! is_null( self::$barcode ) ) {
            echo '<div class="order-item" style="justify-content: center; font-size: 1.1em; font-weight: 700">';
            echo '<span>بارکد پستی:</span><span>';
            echo self::$barcode;
            echo '</span></div>';
        }
        else if ( ! empty( $order->get_meta( 'ow_order_barcode_sdr' ) ) && intval( $mb_options['show_barcode'] ) ) {
            echo '<div class="order-item" style="justify-content: center; font-size: 1.1em; font-weight: 700">';
            echo '<span>بارکد پستی:</span><span>';
            echo $order->get_meta( 'ow_order_barcode_sdr' );
            echo '</span></div>';
        }
    }


	public function ow_afterpayment_complete( $order_id )
	{
		    global $wpdb;

        $order = wc_get_order( $order_id );
		//if ( !empty( $order->get_meta( 'ow_order_added_sdr' ) ) ) return;
        if ( $order->has_status( 'failed' ) ) return;

		$mb_options = get_option('MBGHI_sadr');
        if ( ! isset( $mb_options['register_package'] ) || ! $mb_options['register_package'] ) {
            return;
        }

        $base_url = 'https://sadrcod.com:5001';
        if ( isset( $mb_options['ow_base_url'] ) && $mb_options['ow_base_url'] ) {
            $base_url = sanitize_url( $mb_options['ow_base_url'] );
        }

        if (!empty($mb_options['ow_username']) && !empty($mb_options['ow_password'])) {
            $server_output = wp_remote_post( "{$base_url}/api/security/token/new", array(
                'headers'     => [
                    'Content-Type' => 'application/json',
                ],
                'body' => wp_json_encode( array(
                    'username' => $mb_options['ow_username'],
                    'password' => $mb_options['ow_password'],
                ) ),
            ) );

            if ( !is_wp_error($server_output) && $server_output['response']['code'] == 200 ) {
				if (array_key_exists('ow_api_token', $mb_options)) {
					unset($mb_options['ow_api_token']);
				}

                $server_output = json_decode( $server_output['body'] );
				$mb_options['ow_api_token'] = $server_output->token;
				update_option('MBGHI_sadr', $mb_options);
			}
		}

		$order = wc_get_order($order_id);
		$data = $order->get_data();

		$prepaid = true;
		$payment_method = $data['payment_method'];
		// error_log(  json_encode($item_data));
		if ($payment_method == 'cod') {
			$prepaid = false;
		}

		$city_ID = 0;
		foreach ($data['meta_data'] as $dt) {
			if ($dt->key == '_shipping_city_id') {
				$city_ID = $dt->value;
			}
		}
		
		if(intval($city_ID) < 1) {
			foreach ($data['meta_data'] as $dt) {
				if ($dt->key == '_billing_city_id') {
					$city_ID = $dt->value;
				}
			}
		}

		if ($city_ID == 0) $city_ID = 2;
		$city_ID = get_term($city_ID);
		$city_ID = $city_ID->slug;
		if ($city_ID == 0) $city_ID = 2;

		$ow_out_of_size = (intval($mb_options['out_of_size'])) ? true : false;
		$ow_water_products = (intval($mb_options['water_products'])) ? true : false;
		$ow_broken_products = (intval($mb_options['broken_products'])) ? true : false;
		$ow_send_discount = (intval($mb_options['send_discount'])) ? true : false;
		$ow_tax_discount = (intval($mb_options['tax_discount'])) ? true : false;
		$ow_service_discount = (intval($mb_options['service_discount'])) ? true : false;

		$ow_shop_id = $mb_options['ow_shop_id'];

		$ow_shipping_method = $order->get_shipping_method();

		$ow_product = [];
		foreach ($order->get_items() as $item_id => $item) {
			$item_data = $item->get_data();
			$wc_product = $item->get_product();
			// error_log('fermi itmedata ------> ' .  json_encode($item_data));
			
			$weight = intval($mb_options['product_weight']);
			if ($wc_product->get_weight() > 0) {
				$weight = $wc_product->get_weight();
			}
			$owprice = $item_data['total'] / intval($item_data['quantity']);

			$size = $wc_product->get_attribute('pa_szd');
			$matches = array();
			if (preg_match('/\d+/', $size, $matches)) {
				$size = $matches[0];
			}
			
			$ow_product[] = array(
				'name' => $item->get_name(),
				'price' => $owprice,
				'weight' => $weight,
				'count' => $item_data['quantity'],
				'size' => $size,
                'ProductTypeId' => $wc_product->get_meta( '_productTypeId' ),
			);
			$item->get_name() . PHP_EOL;
			
			if ( $wc_product->is_type( 'variation' ) ) {
				$meta_holder = wc_get_product( $wc_product->get_parent_id() );
			} else {
				$meta_holder = $wc_product;
			}

			if ( ! empty( $meta_holder->get_meta( '_sadr_out_of_size' ) ) ) {
				$ow_out_of_size = true;
			}

			if ( ! empty( $meta_holder->get_meta( '_sadr_broken_product' ) ) ) {
				$ow_broken_products = true;
			}

			if ( ! empty( $meta_holder->get_meta( '_sadr_water_product' ) ) ) {
				$ow_water_products = true;
			}

			if ( ! empty( $meta_holder->get_meta( '_sadr_tax_discount' ) ) ) {
				$ow_tax_discount = true;
			}

			if ( ! empty( $meta_holder->get_meta( '_sadr_service_discount' ) ) ) {
				$ow_service_discount = true;
			}

			if ( ! empty( $meta_holder->get_meta( '_sadr_send_discount' ) ) ) {
				$ow_send_discount = true;
			}
		}

		if (empty($order->get_billing_phone())) {
			$user_phone = $order->get_shipping_phone();
		} else {
			$user_phone = $order->get_billing_phone();
		}

        $ow_shipping_method = 1;
        foreach( $order->get_shipping_methods() as $shipping_method ) {
            if ( $shipping_method->get_method_id() == 'WC_Forehand_Method' ) {
                $shipping_obj = new WC_Forehand_Method( $shipping_method->get_instance_id() );
                if ( $shipping_obj->get_instance_option( 'shipping_sdr_method' ) == 'vije' ) {
                    $ow_shipping_method = 3;    
                }
            }
        }
		
		$domain = parse_url(home_url(), PHP_URL_HOST); // gets current domain, e.g., xyz.com

		$data = array(
			'products' => $ow_product,
			'deliveryType' => $ow_shipping_method,
			'packagingWeight' => intval($mb_options['pack_weight']),
			'prepayment' => $prepaid,
			'destinationCityCode' => intval($city_ID),
			'customerName' => $data['billing']['first_name'] . ' ' . $data['shipping']['last_name'],
			'customerAddress' => $data['billing']['address_1'],
			'customerEmail' => (empty($data['billing']['email'])) ? '' : $data['billing']['email'],
			'customerPostalCode' => (empty($data['billing']['postcode'])) ? '' : $data['billing']['postcode'],
			'customerLandPhone' => $user_phone,
			'customerCellPhone' => $user_phone,
			'customerMessage' => (empty($data['billing']['customer_note'])) ? '' : $data['billing']['customer_note'],
			'customerSubstitute' => false,
			'discountDelivery' => $ow_send_discount,
			'discountTax' => $ow_tax_discount,
			'discountService' => $ow_service_discount,
			'inCash' => $prepaid,
			'outOfSize' => $ow_out_of_size,
			'liquids' => $ow_water_products,
			'fragile' => $ow_broken_products,
			'readyToSend' => (intval($mb_options['ready_to_send'])) ? true : false,
			'shopId' => $ow_shop_id,
			'paymentMethodKey' => $payment_method,
			'refSrc' => $domain
		); 
	
		
			//add payment specfic data
			if ( $payment_method == "melli_bank_sadad" ) {

    // Use your table name with the WP prefix
    $table = $wpdb->prefix . 'sadad_transactions'; // e.g. wp_sadad_transaction

    // Fetch the latest row for this order_id (matched against vr_order_id)
    $row = $wpdb->get_row(
        $wpdb->prepare(
            "SELECT succeed, amount, retrival_ref_no, system_trace_no, vr_order_id
             FROM {$table}
             WHERE vr_order_id = %s
             ORDER BY id DESC
             LIMIT 1",
            (string) $order_id
        ),
        ARRAY_A
    );

    if ($row) {
        // Option A: nest under paymentData
        $data['paymentData'] = array(
            'succeed'         => (int) $row['succeed'],
            'amount'          => $row['amount'],
            'retrival_ref_no' => $row['retrival_ref_no'],
            'system_trace_no' => $row['system_trace_no'],
            'vr_order_id'     => $row['vr_order_id'],
        );
		}
			}

		else if ($payment_method == "mellat_behpardakht"){

		}
		
		$ch = curl_init();
		curl_setopt_array( $ch, [
			CURLOPT_URL            => "{$base_url}/ws/v006/registerPackageV3SadrOnly",
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING       => "",
			CURLOPT_MAXREDIRS      => 1,
			CURLOPT_TIMEOUT        => 10,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION   => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST  => "POST",
			CURLOPT_POSTFIELDS     => json_encode($data),
			CURLOPT_HTTPHEADER     => [
				"Content-type: application/json",
				"Accept: application/json",
				"X-ATJ-Username: " . $mb_options['ow_username'],
				"X-ATJ-Auth-Token: " . $mb_options['ow_api_token']],
		] );

		// error_log('fermi curl token' . $mb_options['ow_api_token']);
		$server_output = curl_exec($ch);
		$server_output = json_decode($server_output);
		// error_log('fermi result' . json_encode($server_output));

        curl_close($ch);
        	
		if (isset($server_output->data)) {
			if (!empty($server_output->data->barcode) && intval($mb_options['show_barcode'])) {
				$order->add_order_note('کد رهگیری پستی: ' . $server_output->data->barcode, true);
                $order->update_meta_data( 'ow_order_barcode_sdr', $server_output->data->barcode );
                self::$barcode = $server_output->data->barcode;
			}

			if (!empty($server_output->data->internalBarcode) && intval($mb_options['show_barcode'])) {
				$order->add_order_note('شناسه رهگیری داخلی مرسوله: ' . $server_output->data->internalBarcode, true);
			} elseif (!empty($server_output->data->internalBarcode) && intval($mb_options['show_barcode']) == 0) {
				$order->add_order_note('شناسه رهگیری داخلی مرسوله: ' . $server_output->data->internalBarcode, false);
				$order->add_order_note('شناسه رهگیری مرسوله: ' . $order_id, true);
			} else {
				$order->add_order_note('شناسه رهگیری داخلی مرسوله: ' . $order_id, true);
			}

            $order->update_meta_data( 'ow_order_added_sdr', '1' );
            $order->save();

		}

		return;
	}

	// Actions
	public function state_city_taxonomy() {

		$labels = [
			'name'              => __( 'شهرها' ),
			'singular_name'     => __( 'شهرها' ),
			'search_items'      => __( 'جستجو شهر' ),
			'all_items'         => __( 'همه شهرها' ),
			'parent_item'       => __( 'استان' ),
			'parent_item_colon' => __( 'استان' ),
			'edit_item'         => __( 'ویرایش شهر' ),
			'update_item'       => __( 'بروزرسانی شهر' ),
			'add_new_item'      => __( 'افزودن شهر جدید' ),
			'new_item_name'     => __( 'نام شهر جدید' ),
			'menu_name'         => __( 'شهرهای حمل و نقل' ),
		];

		register_taxonomy( 'state_city', null, [
			'hierarchical'       => true,
			'labels'             => $labels,
			'query_var'          => false,
			'rewrite'            => false,
			'public'             => false,
			'show_ui'            => true,
			'show_in_quick_edit' => false,
			'show_admin_column'  => false,
			'_builtin'           => true,
			'meta_box_cb'        => false,
		] );

		if ( function_exists( 'PW' ) && PW()->get_options( 'enable_iran_cities' ) != 'no' ) {
			$settings                       = PW()->get_options();
			$settings['enable_iran_cities'] = 'no';
			update_option( 'PW_Options', $settings );
		}
	}

	public function load_shipping_init() {
		require_once MBGHI_DIR . '/methods/MBGHI-method.php';
		require_once MBGHI_DIR . '/methods/MBGHI-pishtaz-method.php';
	}

	public function checkout_update_order_review( $input ) {
		parse_str( $input, $data );

		$billing_district  = isset( $data['billing_district'] ) ? wc_clean( wp_unslash( $data['billing_district'] ) ) : null;
		$shipping_district = isset( $data['shipping_district'] ) ? wc_clean( wp_unslash( $data['shipping_district'] ) ) : null;

		if ( wc_ship_to_billing_address_only() ) {
			$shipping_district = $billing_district;
		}

		WC()->session->set( 'billing_district', $billing_district );
		WC()->session->set( 'shipping_district', $shipping_district );
	}

	public function MBGHI_single_country_field( $value ) {
		$country_setting = get_option( $value['id'] );

		if ( strstr( $country_setting, ':' ) ) {
			[ $country, $state ] = explode( ':', $country_setting );

			if ( is_numeric( $state ) ) {
				$state = intval( $state );
			}
		} else {
			$country = $country_setting;
			$state   = '*';
		}

		?>
		<tr valign="top">
		<th scope="row" class="titledesc">
			<label for="<?php echo esc_attr( $value['id'] ); ?>"><?php echo esc_html( $value['title'] ); ?></label>
		</th>
		<td class="forminp">
			<select name="<?php echo esc_attr( $value['id'] ); ?>"
					style="<?php echo esc_attr( $value['css'] ); ?>"
					data-placeholder="<?php esc_attr_e( 'Choose a country&hellip;', 'woocommerce' ); ?>"
					aria-label="<?php esc_attr_e( 'Country', 'woocommerce' ) ?>"
					class="wc-enhanced-select">
				<?php WC()->countries->country_dropdown_options( $country, $state ); ?>
			</select>
		</td>
		</tr><?php
	}

	public function enqueue_select2_scripts() {
		if ( ! is_checkout() ) {
			return false;
		}

		wp_register_script( 'selectWoo', WC()->plugin_url() . '/assets/js/selectWoo/selectWoo.full.min.js', [ 'jquery' ], '4.0.3' );
		wp_enqueue_script( 'selectWoo' );
		wp_register_style( 'select2', WC()->plugin_url() . '/assets/css/select2.css' );
		wp_enqueue_style( 'select2' );

		wp_register_script( 'MBGHICheckout', MBGHI_URL . 'assets/js/MBGHI.js', [ 'selectWoo' ], '1.0.0' );
		wp_localize_script( 'MBGHICheckout', 'MBGHI_settings', [
			'ajax_url' => admin_url( 'admin-ajax.php' ),
			'types'    => $this->types(),
		] );
		wp_enqueue_script( 'MBGHICheckout' );
	}

	// Filters

	public function add_shipping_method( $methods ) {

		foreach ( self::$methods as $new_method ) {
			if ( class_exists( $new_method ) ) {
				$methods[ $new_method ] = $new_method;
			}
		}

		return $methods;
	}

	public function get_settings_general( $settings ) {

		foreach ( $settings as &$setting ) {

			if ( $setting['id'] == 'woocommerce_default_country' ) {
				$setting['type'] = 'MBGHI_single_country';
			}

		}

		return $settings;
	}

	public function iran_states( $states ) {

		$states['IR'] = MBGHI()->states();

		return $states;
	}

	public function edit_state_city_columns_taxonomy( $original_columns ) {

		unset( $original_columns['posts'] );
		$original_columns['city_id'] = "شناسه شهر";

		return $original_columns;
	}

	public function edit_state_city_rows_taxonomy( $row, $column_name, $term_id ) {

		if ( 'city_id' === $column_name ) {
			return $term_id;
		}

		return $row;
	}

	public function edit_checkout_cities_field( $fields ) {

		$types = $this->types();

		foreach ( $types as $type ) {

			if ( ! isset( $fields[ $type ][ $type . '_city' ] ) ) {
				continue;
			}

			$fields[ $type ][ $type . '_state' ]['placeholder'] = __( 'استان خود را انتخاب نمایید' );

			$default_state_id = apply_filters( 'MBGHI_default_state', 0, $type );

			if ( $default_state_id ) {
				$fields[ $type ][ $type . '_state' ]['default'] = $default_state_id;
			}

			$class = is_array( $fields[ $type ][ $type . '_city' ]['class'] ) ? $fields[ $type ][ $type . '_city' ]['class'] : [];

			$fields[ $type ][ $type . '_city' ] = [
				'type'        => $type . '_city',
				'label'       => __( 'شهر' ),
				'placeholder' => __( 'لطفا ابتدا استان خود را انتخاب نمایید' ),
				'required'    => true,
				'id'          => $type . '_city',
				'class'       => apply_filters( 'MBGHI_city_class', $class ),
				'default'     => apply_filters( 'MBGHI_default_city', 0, $type, null ),
				'priority'    => apply_filters( 'MBGHI_city_priority', $fields[ $type ][ $type . '_city' ]['priority'] ),
			];

			// if ( ! MBGHI_Sadr::is_enable() ) {
			// 	$fields[ $type ][ $type . '_district' ] = [
			// 		'type'        => $type . '_district',
			// 		'label'       => __( 'محله' ),
			// 		'placeholder' => __( 'لطفا محله خود را انتخاب نمایید' ),
			// 		'required'    => false,
			// 		'id'          => $type . '_district',
			// 		'class'       => apply_filters( 'MBGHI_district_class', $class ),
			// 		'clear'       => true,
			// 		'default'     => apply_filters( 'MBGHI_default_district', 0, $type, null ),
			// 		'priority'    => apply_filters( 'MBGHI_district_priority', $fields[ $type ][ $type . '_city' ]['priority'] + 1 ),
			// 	];
			// }

		}

		return $fields;
	}

	public function checkout_update_order_meta( $order_id ) {

		$types  = $this->types();
		$fields = [ 'state', 'city' ];//district

        $order = wc_get_order( $order_id );

		foreach ( $types as $type ) {

			foreach ( $fields as $field ) {

				$term_id = $order->get_meta( "_{$type}_{$field}", true );
				$term    = get_term( intval( $term_id ) );

				if ( ! is_wp_error( $term ) && ! is_null( $term ) ) {
					$order->update_meta_data( "_{$type}_{$field}", $term->name );
                    $order->update_meta_data( "_{$type}_{$field}_id", $term_id );
				}

			}
		}

		if ( wc_ship_to_billing_address_only() ) {

			foreach ( $fields as $field ) {

				$label = $order->get_meta( "_billing_{$field}", true );
				$id    = $order->get_meta( "_billing_{$field}_id", true );

                $order->update_meta_data( "_shipping_{$field}", $label );
                $order->update_meta_data( "_shipping_{$field}_id", $id );
			}

		}

        $order->save();

	}

	public function checkout_process() {

		$types = $this->types();

		$fields = [
			'state'    => 'استان',
			'city'     => 'شهر',
			// 'district' => 'محله',
		];

		$type_label = [
			'billing'  => 'صورتحساب',
			'shipping' => 'حمل و نقل',
		];

		if ( ! isset( $_POST['ship_to_different_address'] ) && count( $types ) == 2 ) {
			unset( $types[1] );
		}

		foreach ( $types as $type ) {

			$label = $type_label[ $type ];

			foreach ( $fields as $field => $name ) {

				$key = $type . '_' . $field;

				if ( isset( $_POST[ $key ] ) && strlen( $_POST[ $key ] ) ) {

					$term_id = intval( $_POST[ $key ] );

					if ( $term_id == 0 ) {
						$message = sprintf( 'لطفا <b>%s %s</b> خود را انتخاب نمایید.', $name, $label );
						wc_add_notice( $message, 'error' );

						continue;
					}

					/** @var WP_Term $term */
					$term = get_term( $term_id, 'state_city' );

					if ( is_wp_error( $term ) || is_null( $term ) ) {
						$message = sprintf( '<b>%s %s</b> انتخاب شده معتبر نمی باشد.', $name, $label );
						wc_add_notice( $message, 'error' );

						continue;
					}

					if ( $field == 'city' ) {

						$pkey = $type . '_state';

						if ( isset( $_POST[ $pkey ] ) && ! empty( $_POST[ $pkey ] ) && $term->parent != $_POST[ $pkey ] ) {
							$message = sprintf( '<b>استان</b> با <b>شهر</b> %s انتخاب شده همخوانی ندارند.', $label );
							wc_add_notice( $message, 'error' );

							continue;
						}
					}

					// if ( $field == 'district' ) {

					// 	$pkey = $type . '_city';

					// 	if ( isset( $_POST[ $pkey ] ) && ! empty( $_POST[ $pkey ] ) && $term->parent != $_POST[ $pkey ] ) {
					// 		$message = sprintf( '<b>شهر</b> با <b>محله</b> %s انتخاب شده همخوانی ندارند.', $label );
					// 		wc_add_notice( $message, 'error' );
					// 	}
					// }
				}

			}

		}
	}

	public function checkout_cities_field( $field, $key, $args, $value ): string {

		$field_html = '';
		$options    = [];

		[ $type, $name ] = explode( '_', $args['type'] );

		if ( $name == 'city' ) {

			$default_state_id = apply_filters( 'MBGHI_default_state', 0, $type );

			$state_id = WC()->checkout()->get_value( $type . '_state' );

			if ( $state_id ) {
				$options = MBGHI()->cities( $state_id );
			} elseif ( $default_state_id ) {
				$options = MBGHI()->cities( $default_state_id );
			}

		} 
		//elseif ( $name == 'district' ) {

		// 	$city_id = WC()->checkout()->get_value( $type . '_city' );

		// 	if ( $city_id ) {
		// 		$options = get_terms( [
		// 			'taxonomy'   => 'state_city',
		// 			'hide_empty' => false,
		// 			'child_of'   => $city_id,
		// 		] );

		// 		$options = array_column( $options, 'name', 'term_id' );
		// 	}

		// }

		$ignore_classes = [
			'thwcfd-optional',
			'thwcfd-field-wrapper',
			'thwcfd-field-text',
		];

		$args['class'] = array_diff( $args['class'], $ignore_classes );

		$args['class'][] = 'validate-required';
		$required        = '&nbsp;<abbr class="required" title="' . esc_attr__( 'required', 'woocommerce' ) . '">*</abbr>';

		if ( is_string( $args['label_class'] ) ) {
			$args['label_class'] = [ $args['label_class'] ];
		}

		if ( is_null( $value ) ) {
			$value = $args['default'];
		}

		$custom_attributes = [];

		if ( ! empty( $args['custom_attributes'] ) && is_array( $args['custom_attributes'] ) ) {
			foreach ( $args['custom_attributes'] as $attribute => $attribute_value ) {
				$custom_attributes[] = esc_attr( $attribute ) . '="' . esc_attr( $attribute_value ) . '"';
			}
		}

		if ( ! empty( $args['validate'] ) ) {
			foreach ( $args['validate'] as $validate ) {
				$args['class'][] = 'validate-' . $validate;
			}
		}

		$sort            = $args['priority'] ? $args['priority'] : '';
		$field_container = '<p class="form-row %1$s" id="%2$s" data-priority="' . esc_attr( $sort ) . '">%3$s</p>';

		if ( is_array( $options ) ) {

			if ( empty( $options ) && $name == 'district' ) {
				$field_container = '<p class="form-row %1$s" id="%2$s" style="display: none">%3$s</p>';
			}

			$field .= '<select name="' . esc_attr( $key ) . '" id="' . esc_attr( $args['id'] ) . '" class="' . esc_attr( implode( ' ', $args['input_class'] ) ) . '" ' . implode( ' ', $custom_attributes ) . ' data-placeholder="' . esc_attr( $args['placeholder'] ) . '">';

			if ( count( $options ) ) {
				$field .= '<option value="0">' . esc_attr( $args['placeholder'] ) . '</option>';
			}

			foreach ( $options as $id => $label ) {
				if ( $name == 'city' ) {
					$field .= '<option value="' . esc_attr( $id ) . '" ' . selected( $value, $id, false ) . '>' . $label . '</option>';
				} elseif ( $name == 'district' ) {
					$ancestors = get_ancestors( $id, 'state_city' );
					$indent    = str_repeat( '- ', max( count( $ancestors ) - 2, 0 ) );
					$field     .= '<option value="' . esc_attr( $id ) . '" ' . selected( $value, $id, false ) . '>' . $indent . $label . '</option>';
				}
			}

			$field .= '</select>';

		}

		if ( $args['label'] ) {
			$field_html .= '<label for="' . esc_attr( $args['id'] ) . '" class="' . esc_attr( implode( ' ', $args['label_class'] ) ) . '">' . $args['label'] . $required . '</label>';
		}

		$field_html .= $field;

		if ( $args['description'] ) {
			$field_html .= '<span class="description">' . esc_html( $args['description'] ) . '</span>';
		}

		$container_class = 'form-row ' . esc_attr( implode( ' ', $args['class'] ) );
		$container_id    = esc_attr( $args['id'] ) . '_field';

		$after = ! empty( $args['clear'] ) ? '<div class="clear"></div>' : '';

		return sprintf( $field_container, $container_class, $container_id, $field_html ) . $after;
	}

	public function cart_shipping_packages( $packages ) {

		$type = 'billing';

		if ( isset( $_POST['post_data'] ) ) {
			parse_str( $_POST['post_data'], $data );
		} else {
			$data = WC()->checkout()->get_posted_data();
		}

		if ( isset( $data['ship_to_different_address'] ) && in_array( 'shipping', $this->types() ) ) {
			$type = 'shipping';
		}

		for ( $i = 0; $i < count( $packages ); $i ++ ) {
			$packages[ $i ]['destination']['district'] = $data[ $type . '_district' ] ?? null;
		}

		return $packages;
	}

	public function shipping_method_image( $label, $method ) {


        if ( $method->method_id != 'WC_Forehand_Method' ) {
            return $label;
        }

        $new_label = '<a style="color: #19bfd3;" href="https://sadrcod.ir/%d9%85%d8%ad%d8%a7%d8%b3%d8%a8%d9%87-%d9%82%db%8c%d9%85%d8%aa/" target="_blank">';

		$method_id = str_replace( ':', '_', $method->id );
		$option    = get_option( "woocommerce_{$method_id}_settings" );

		if ( isset( $option['img_url'] ) && ! empty( $option['img_url'] ) ) {
			$new_label .= sprintf( '<img src="%s" class="MBGHI-method-image %s %s" style="max-width: 100px;display: inline;"/>', $option['img_url'], $method_id, strtok( $method->id, ':' ) ) . $label;
        } else {
            $new_label .= $label;
        }

        if ( $method->method_id == 'WC_Forehand_Method' ) {
             $new_label .= '</a>';
        }

		return $new_label;
	}

	public function localisation_address_formats( $formats ) {

		$formats['IR'] = "{company}\n{first_name} {last_name}\n{country}\n{state}\n{city}\n{district}\n{address_1}\n{address_2}\n{postcode}";

		return $formats;
	}

	public function order_formatted_shipping_address( $data, $order ) {

		if ( is_array( $data ) ) {
			$data['district'] = $order->get_meta( '_shipping_district', true );
		}

		return $data;
	}

	public function order_formatted_billing_address( $data, $order ) {

		if ( is_array( $data ) ) {
			$data['district'] = $order->get_meta( '_billing_district', true );
		}

		return $data;
	}

	public function formatted_address_replacements( $replace, $args ) {

		if ( ctype_alnum( $replace['{state}'] ) && strlen( $replace['{state}'] ) == 2 ) {
			$state              = get_term_by( 'slug', $replace['{state}'], 'state_city' );
			$replace['{state}'] = $state == false ? $replace['{state}'] : $state->name;
		}

		if ( ctype_alnum( $replace['{state}'] ) && strlen( $replace['{state}'] ) == 3 && function_exists( 'PW' ) ) {
			$replace['{state}'] = PW()->address->states[ $args['state'] ] ?? $args['state'];
		}

		if ( ctype_alnum( $replace['{state}'] ) && strlen( $replace['{state}'] ) == 3 ) {
			$state              = get_term_by( 'slug', $replace['{state}'], 'state_city' );
			$replace['{state}'] = $state == false ? $replace['{state}'] : $state->name;
		}

		if ( ctype_digit( $args['city'] ) ) {
			$city              = get_term( $args['city'] );
			$replace['{city}'] = is_wp_error( $city ) || is_null( $city ) ? $args['city'] : $city->name;
		}

		// if ( isset( $args['district'] ) ) {
		// 	$district              = get_term( intval( $args['district'] ) );
		// 	$replace['{district}'] = is_wp_error( $district ) ? $args['district'] : $district->name;
		// } else {
			$replace['{district}'] = null;
		//}

		return $replace;
	}

	function my_account_my_address_formatted_address( $args, $customer_id, $name ) {

		$args['district'] = get_user_meta( $customer_id, $name . '_district', true );

		return $args;
	}

	public function checkout_get_value( $value, $key ) {

		if ( ! in_array( $key, [ 'billing_district', 'shipping_district' ] ) ) {
			return $value;
		}

		return WC()->session->get( $key, 0 );
	}

	// Functions

	public function types() {

		$types = [ 'billing' ];

		if ( ! wc_ship_to_billing_address_only() ) {
			$types[] = 'shipping';
		}

		return $types;
	}

	public static function states() {

		$states = get_transient( 'MBGHI_states' );

		if ( $states === false || count( (array) $states ) == 0 ) {

			$states = get_terms( [
				'taxonomy'   => 'state_city',
				'hide_empty' => false,
				'parent'     => 0,
			] );			

			$states = wp_list_pluck( $states, 'name', 'term_id' );

			uasort( $states, [ self::class, 'MBGHI_sort_state' ] );

			set_transient( 'MBGHI_states', $states, DAY_IN_SECONDS );
		}

		return apply_filters( 'MBGHI_states', $states );
	}

	public static function get_state( $state_id ) {

		$states = MBGHI()->states();

		return $states[ $state_id ] ?? null;
	}

	public static function cities( $state_id ) {

		$cities = get_transient( 'MBGHI_cities_' . $state_id );

		if ( $cities === false || count( (array) $cities ) == 0 ) {

			$cities = get_terms( [
				'taxonomy'   => 'state_city',
				'hide_empty' => false,
				'parent'     => $state_id,
			] );

			if ( is_wp_error( $cities ) ) {
				$cities = [];
			} else {
				$cities = array_column( $cities, 'name', 'term_id' );
			}

			set_transient( 'MBGHI_cities_' . $state_id, $cities, DAY_IN_SECONDS );
		}

		return apply_filters( 'MBGHI_cities', $cities, $state_id );
	}

	public static function get_city( $city_id ) {

		$city = get_term( $city_id, 'state_city' );

		return is_wp_error( $city ) || is_null( $city ) ? null : $city->name;
	}

	public function check_states_beside( $source, $destination ) {

		if ( $source == $destination ) {
			return 'in';
		}

		$is_beside["AE"]["AW"] = true;
		$is_beside["AE"]["AR"] = true;
		$is_beside["AE"]["ZA"] = true;

		$is_beside["AW"]["AE"] = true;
		$is_beside["AW"]["KD"] = true;
		$is_beside["AW"]["ZA"] = true;

		$is_beside["AR"]["AE"] = true;
		$is_beside["AR"]["GI"] = true;
		$is_beside["AR"]["ZA"] = true;

		$is_beside["IS"]["CM"] = true;
		$is_beside["IS"]["LO"] = true;
		$is_beside["IS"]["KB"] = true;
		$is_beside["IS"]["MK"] = true;
		$is_beside["IS"]["QM"] = true;
		$is_beside["IS"]["SM"] = true;
		$is_beside["IS"]["KJ"] = true;
		$is_beside["IS"]["YA"] = true;
		$is_beside["IS"]["FA"] = true;

		$is_beside["AL"]["TE"] = true;
		$is_beside["AL"]["MK"] = true;
		$is_beside["AL"]["QZ"] = true;
		$is_beside["AL"]["MN"] = true;

		$is_beside["IL"]["BK"] = true;
		$is_beside["IL"]["LO"] = true;
		$is_beside["IL"]["KZ"] = true;

		$is_beside["BU"]["KB"] = true;
		$is_beside["BU"]["KZ"] = true;
		$is_beside["BU"]["FA"] = true;
		$is_beside["BU"]["HG"] = true;

		$is_beside["TE"]["AL"] = true;
		$is_beside["TE"]["MK"] = true;
		$is_beside["TE"]["QM"] = true;
		$is_beside["TE"]["MN"] = true;
		$is_beside["TE"]["SM"] = true;

		$is_beside["CM"]["KB"] = true;
		$is_beside["CM"]["KZ"] = true;
		$is_beside["CM"]["LO"] = true;
		$is_beside["CM"]["IS"] = true;

		$is_beside["KJ"]["SB"] = true;
		$is_beside["KJ"]["KE"] = true;
		$is_beside["KJ"]["YA"] = true;
		$is_beside["KJ"]["IS"] = true;
		$is_beside["KJ"]["SM"] = true;
		$is_beside["KJ"]["KV"] = true;

		$is_beside["KV"]["KJ"] = true;
		$is_beside["KV"]["KS"] = true;
		$is_beside["KV"]["SM"] = true;

		$is_beside["KS"]["KV"] = true;
		$is_beside["KS"]["GO"] = true;
		$is_beside["KS"]["SM"] = true;

		$is_beside["KZ"]["IL"] = true;
		$is_beside["KZ"]["BU"] = true;
		$is_beside["KZ"]["LO"] = true;
		$is_beside["KZ"]["KB"] = true;
		$is_beside["KZ"]["CM"] = true;

		$is_beside["ZA"]["GI"] = true;
		$is_beside["ZA"]["AR"] = true;
		$is_beside["ZA"]["AE"] = true;
		$is_beside["ZA"]["AW"] = true;
		$is_beside["ZA"]["KD"] = true;
		$is_beside["ZA"]["HD"] = true;
		$is_beside["ZA"]["QZ"] = true;

		$is_beside["SM"]["MN"] = true;
		$is_beside["SM"]["TE"] = true;
		$is_beside["SM"]["QM"] = true;
		$is_beside["SM"]["IS"] = true;
		$is_beside["SM"]["KS"] = true;
		$is_beside["SM"]["KV"] = true;
		$is_beside["SM"]["KJ"] = true;

		$is_beside["SB"]["KJ"] = true;
		$is_beside["SB"]["KE"] = true;
		$is_beside["SB"]["HG"] = true;

		$is_beside["FA"]["IS"] = true;
		$is_beside["FA"]["YA"] = true;
		$is_beside["FA"]["BU"] = true;
		$is_beside["FA"]["HG"] = true;
		$is_beside["FA"]["KB"] = true;
		$is_beside["FA"]["KE"] = true;

		$is_beside["QZ"]["ZA"] = true;
		$is_beside["QZ"]["HD"] = true;
		$is_beside["QZ"]["MK"] = true;
		$is_beside["QZ"]["AL"] = true;
		$is_beside["QZ"]["MN"] = true;
		$is_beside["QZ"]["GI"] = true;

		$is_beside["QM"]["TE"] = true;
		$is_beside["QM"]["MK"] = true;
		$is_beside["QM"]["SM"] = true;
		$is_beside["QM"]["IS"] = true;

		$is_beside["KD"]["AW"] = true;
		$is_beside["KD"]["BK"] = true;
		$is_beside["KD"]["HD"] = true;
		$is_beside["KD"]["ZA"] = true;

		$is_beside["KE"]["YA"] = true;
		$is_beside["KE"]["FA"] = true;
		$is_beside["KE"]["HG"] = true;
		$is_beside["KE"]["SB"] = true;
		$is_beside["KE"]["KJ"] = true;

		$is_beside["BK"]["KD"] = true;
		$is_beside["BK"]["HD"] = true;
		$is_beside["BK"]["LO"] = true;
		$is_beside["BK"]["IL"] = true;

		$is_beside["KB"]["CM"] = true;
		$is_beside["KB"]["KZ"] = true;
		$is_beside["KB"]["BU"] = true;
		$is_beside["KB"]["FA"] = true;
		$is_beside["KB"]["IS"] = true;

		$is_beside["GO"]["MN"] = true;
		$is_beside["GO"]["KS"] = true;
		$is_beside["GO"]["SM"] = true;

		$is_beside["GI"]["MN"] = true;
		$is_beside["GI"]["AR"] = true;
		$is_beside["GI"]["ZA"] = true;
		$is_beside["GI"]["QZ"] = true;

		$is_beside["LO"]["IL"] = true;
		$is_beside["LO"]["BK"] = true;
		$is_beside["LO"]["HD"] = true;
		$is_beside["LO"]["MK"] = true;
		$is_beside["LO"]["IS"] = true;
		$is_beside["LO"]["CM"] = true;
		$is_beside["LO"]["KZ"] = true;

		$is_beside["MN"]["GO"] = true;
		$is_beside["MN"]["SM"] = true;
		$is_beside["MN"]["TE"] = true;
		$is_beside["MN"]["AL"] = true;
		$is_beside["MN"]["IS"] = true;
		$is_beside["MN"]["QZ"] = true;
		$is_beside["MN"]["GI"] = true;

		$is_beside["MK"]["IS"] = true;
		$is_beside["MK"]["QM"] = true;
		$is_beside["MK"]["TE"] = true;
		$is_beside["MK"]["AL"] = true;
		$is_beside["MK"]["LO"] = true;
		$is_beside["MK"]["QZ"] = true;
		$is_beside["MK"]["HD"] = true;

		$is_beside["HG"]["BU"] = true;
		$is_beside["HG"]["FA"] = true;
		$is_beside["HG"]["KE"] = true;
		$is_beside["HG"]["SB"] = true;

		$is_beside["HD"]["BK"] = true;
		$is_beside["HD"]["LO"] = true;
		$is_beside["HD"]["KD"] = true;
		$is_beside["HD"]["MK"] = true;
		$is_beside["HD"]["QZ"] = true;
		$is_beside["HD"]["ZA"] = true;

		$is_beside["YA"]["FA"] = true;
		$is_beside["YA"]["KE"] = true;
		$is_beside["YA"]["KJ"] = true;

		$source      = get_term( $source, 'state_city' );
		$destination = get_term( $destination, 'state_city' );

		if ( is_wp_error( $source ) || is_wp_error( $destination ) ) {
			return false;
		}

		$source      = strval( $source->slug ?? null );
		$destination = strval( $destination->slug ?? null );

		return isset( $is_beside[ strtoupper( $source ) ][ strtoupper( $destination ) ] ) && $is_beside[ strtoupper( $source ) ][ strtoupper( $destination ) ] === true ? 'beside' : 'out';
	}

	public function convert_currency( $price ) {

		switch ( get_woocommerce_currency() ) {
			case 'IRT':
				$price /= 10;
				break;
			case 'IRHR':
				$price /= 1000;
				break;
			case 'IRHT':
				$price /= 10000;
				break;
		}

		return ceil( $price );
	}


	public function get_term_option( $term_id ): array {

		$option = get_option( 'nabik_taxonomy_' . $term_id, [] );

		return apply_filters( 'MBGHI_get_term_option', $option, $term_id );
	}

	public function set_term_option( $term_id, array $option ) {

		$option = apply_filters( 'MBGHI_set_term_option', $option, $term_id );

		update_option( 'nabik_taxonomy_' . $term_id, $option );
	}

	public function delete_term_option( $term_id ) {
		delete_option( 'nabik_taxonomy_' . $term_id );
	}

	public function get_terms_option( $term_id ) {

		$options = wp_cache_get( 'get_terms_option_' . $term_id, 'MBGHI' );

		if ( false !== $options ) {
			return $options;
		}

		$ancestors = get_ancestors( $term_id, 'state_city' );

		if ( empty( $ancestors ) ) {
			return [];
		}

		array_unshift( $ancestors, $term_id );

		$options = array_map( [ $this, 'get_term_option' ], $ancestors );

		wp_cache_set( 'get_terms_option_' . $term_id, $options, 'MBGHI' );

		return $options;
	}

	public static function get_option( string $option_name, $default = null ) {

		[ $section, $option ] = explode( '.', $option_name );

		$options = get_option( 'MBGHI_' . $section, [] );

		if ( isset( $options[ $option ] ) ) {
			return $options[ $option ];
		}

		return $default;
	}

	public static function set_option( string $option_name, $value ) {

		[ $section, $option ] = explode( '.', $option_name );

		$options = get_option( 'MBGHI_' . $section, [] );
		$options = empty( $options ) ? [] : $options;

		$options[ $option ] = $value;

		update_option( 'MBGHI_' . $section, $options );
	}


	public static function MBGHI_sort_state( $a, $b ) {

		if ( $a == $b ) {
			return 0;
		}

		$mb_options = get_option('MBGHI_sadr');

        $base_url = 'https://sadrcod.com:5001';
        if ( isset( $mb_options['ow_base_url'] ) && $mb_options['ow_base_url'] ) {
            $base_url = sanitize_url( $mb_options['ow_base_url'] );
        }

        $states = [];
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, "{$base_url}/api/province/query?page=1&pageSize=100" );
		curl_setopt($ch, CURLOPT_HEADER, 0);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		$server_output = curl_exec($ch);
		$server_output = json_decode($server_output);

		curl_close($ch);


		if ( ! isset( $server_output->data ) ) {
            return;
        }

		foreach ($server_output->data as $ow_states) {
			$states[] = $ow_states->name;
		}

		$a = str_replace( [ 'ي', 'ك', 'ة' ], [ 'ی', 'ک', 'ه' ], $a );
		$b = str_replace( [ 'ي', 'ك', 'ة' ], [ 'ی', 'ک', 'ه' ], $b );

		$a_key = array_search( trim( $a ), $states );
		$b_key = array_search( trim( $b ), $states );

		return $a_key < $b_key ? - 1 : 1;
	}

	public function MBGHI_pro_url( $source ): string {
		return true;
	}

}
