<?php
defined( 'ABSPATH' ) || exit;

class MBGHI_Order {

	public static function get_weight( WC_Order $order ): float {

		$weight = $order->get_meta( 'sadr_weight' );

		if ( empty( $weight ) ) {

			$weight = floatval( MBGHI()->get_option( 'tools.package_weight', 500 ) );

			foreach ( $order->get_items() as $order_item ) {

				$product = $order_item->get_product();

				if ( is_bool( $product ) || $product->is_virtual() ) {
					continue;
				}

				$weight += MBGHI_Product::get_weight( $product ) * $order_item->get_quantity();
			}

		}

		return apply_filters( 'MBGHI_order_weight', $weight, $order );
	}

	public static function get_shipping_method( WC_Order $order, $label = false ) {

		$shipping_method = null;

		foreach ( $order->get_shipping_methods() as $shipping_item ) {
			if ( strpos( $shipping_item->get_method_id(), 'Sadr_Pishtaz_Method' ) === 0 ) {
				$shipping_method = 1;
			} else if ( strpos( $shipping_item->get_method_id(), 'Sadr_Sefareshi_Method' ) === 0 ) {
				$shipping_method = 0;
			}
		}

		$labels = [
			'سفارشی',
			'پیشتاز',
		];

		if ( $label ) {
			return $labels[ $shipping_method ] ?? null;
		}

		return $shipping_method;
	}

}
