<?php
defined( 'ABSPATH' ) || exit;

class MBGHI_Install {

	public function __construct() {
		add_action( 'admin_init', [ $this, 'activated_plugin' ], 20 );
	}

	public function activated_plugin() {

		if ( ! file_exists( MBGHI_DIR . '/.activated' ) ) {
			return;
		}

		if ( 'yes' === get_transient( 'MBGHI_admin_installing' ) ) {
			return;
		}

		set_transient( 'MBGHI_admin_installing', 'yes', MINUTE_IN_SECONDS * 10 );

		set_time_limit( 0 );

		self::install_cities();

		delete_transient( 'MBGHI_admin_installing' );

		update_option( 'MBGHI_version', MBGHI_VERSION );

		unlink( MBGHI_DIR . '/.activated' );
	}

	public function install_cities() {
		global $wp_filter;

		unset( $wp_filter['delete_state_city'] );
		unset( $wp_filter['edited_state_city'] );
		unset( $wp_filter['created_state_city'] );

		if ( get_option( 'sabira_set_iran_cities', 0 ) || get_option( 'MBGHI_install_cities', 0 ) ) {
			return;
		}

		require_once( MBGHI_DIR . '/data/state_city.php' );

		foreach ( MBGHI_get_states() as $key => $state ) {
			$term = wp_insert_term( $state, 'state_city', [ 'slug' => $key, 'description' => "استان $state" ] );

			if ( is_wp_error( $term ) ) {
				continue;
			}

			foreach (MBGHI_get_state_city($key) as $key => $city) {
				wp_insert_term( $city, 'state_city', [
					'parent'      => $term['term_id'],
					'slug'        => $key,
					'description' => "$state - $city",
				] );
			}
		}

		update_option( 'MBGHI_install_cities', 1 );
	}
}

new MBGHI_Install();
