<?php
class MBGHI_Settings_Sadr extends MBGHI_Settings {

	protected static $_instance = null;

	public static function instance() {

		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}

		return self::$_instance;
	}

	public function get_sections(): array {
		return [
			[
				'id'    => 'MBGHI_sadr',
				'title' => 'پیشخوان مجازی صدر',
			],
		];
	}

	public function get_fields(): array {
		if ( ( $_GET['page'] ?? null ) == 'MBGHI-sadr' ) {
			do_action( 'MBGHI_state_city_updated' );
		}

		$mb_options = get_option('MBGHI_sadr');

        $base_url = 'https://sadrcod.com:5001';
        if ( ! empty( $mb_options['ow_base_url'] ) ) {
            $base_url = sanitize_url( $mb_options['ow_base_url'] );
        }

		if (!empty($mb_options['ow_username']) && !empty($mb_options['ow_password']) && empty($mb_options['ow_api_token'])) {
            $server_output = wp_remote_post( "{$base_url}/api/security/token/new", array(
                'headers'     => [
                    'Content-Type' => 'application/json',
                ],
                'body' => wp_json_encode( array(
                    'username' => $mb_options['ow_username'],
                    'password' => $mb_options['ow_password'],
                ) ),
            ) );


            if ( ! is_wp_error( $server_output ) && $server_output['response']['code'] == 200 ) {
                if (array_key_exists('ow_api_token', $mb_options)) {
                    unset($mb_options['ow_api_token']);
                }

                $server_output = json_decode( $server_output['body'] );
                $mb_options['ow_api_token'] = $server_output->token;
                update_option('MBGHI_sadr', $mb_options);
            }
        }

        return [
            'MBGHI_sadr' => [
                [
                    'label'   => 'نام کاربری',
                    'name'    => 'ow_username',
                    'default' => null,
                    'type'    => 'text',
                    'desc'    => 'نام کاربری حساب صدر را وارد کنید.',
                ],
                [
                    'label'   => 'رمز عبور',
                    'name'    => 'ow_password',
                    'default' => null,
                    'type'    => 'password',
                    'desc'    => 'رمز عبور حساب کاربری صدر را وارد کنید.',
                ],
                [
                    'label'   => 'آدرس ای‌پی‌آی',
                    'name'    => 'ow_base_url',
                    'default' => 'https://sadrcod.com:5001',
                    'type'    => 'url',
                    'desc'    => 'آدرسی که درخواست‌ها به آن ارسال می‌شود.'
                ],
                [
                    'label'   => 'آیدی فروشگاه',
                    'name'    => 'ow_shop_id',
                    'default' => null,
                    'type'    => 'text',
                    'desc' 	  => 'آیدی فروشگاه خود را وارد کنید.'
                ],
                [
                    'label'   => 'توکن',
                    'name'    => 'ow_api_token',
                    'default' => null,
                    'type'    => 'text',
                    'desc'    => 'این فیلد را دست نزنید... به صورت خودکار از طریق نام کاربری و رمز عبور پنل صدر تکمیل خواهد شد... در صورتی که پس از پر کردن اطلاعات ورود این فیلد پر نشد، اطلاعات وارد شده غلط میباشد...',
                ],
                [
                    'label'   => 'تخفیف مالیات',
                    'name'    => 'tax_discount',
                    'default' => '0',
                    'type'    => 'checkbox',
                    'desc'    => '',
                ],
                [
                    'label'   => 'تخفیف خدمات',
                    'name'    => 'service_discount',
                    'default' => '0',
                    'type'    => 'checkbox',
                    'desc'    => '',
                ],
                [
                    'label'   => 'تخفیف هزینه ارسال',
                    'name'    => 'send_discount',
                    'default' => '0',
                    'type'    => 'checkbox',
                    'desc'    => '',
                ],
                [
                    'label'   => 'محصولات آماده به ارسال اند؟',
                    'name'    => 'ready_to_send',
                    'default' => '0',
                    'type'    => 'checkbox',
                    'desc'    => '',
                ],
                [
                    'label'   => 'نمایش بارکد پستی به کاربر',
                    'name'    => 'show_barcode',
                    'default' => '0',
                    'type'    => 'checkbox',
                    'desc'    => '',
                ],
                [
                    'label'   => 'محصولات خارج از اندازه؟',
                    'name'    => 'out_of_size',
                    'default' => '0',
                    'type'    => 'checkbox',
                    'desc'    => '',
                ],
                [
                    'label'   => 'محصولات شکستنی',
                    'name'    => 'broken_products',
                    'default' => '0',
                    'type'    => 'checkbox',
                    'desc'    => '',
                ],
                [
                    'label'   => 'محصولات مایعات',
                    'name'    => 'water_products',
                    'default' => '0',
                    'type'    => 'checkbox',
                    'desc'    => '',
                ],
                [
                    'label'   => 'محاسبه موجودی کالا',
                    'name'    => 'calc_product_qty',
                    'default' => '0',
                    'type'    => 'checkbox',
                    'desc'    => '',
                ],
                [
                    'label'   => 'ارسال سفارش به پنل',
                    'name'    => 'register_package',
                    'default' => '0',
                    'type'    => 'checkbox',
                    'desc'    => '',
                ],
                [
                    'label'   => 'وزن پیشفرض هر محصول',
                    'name'    => 'product_weight',
                    'default' => 200,
                    'type'    => 'number',
                    'desc'    => "در صورتی که برای محصول وزنی وارد نشده بود، بصورت پیشفرض وزن محصول چند گرم در نظر گرفته شود؟",
                ],
                [
                    'label'   => 'وزن پیشفرض بسته بندی',
                    'name'    => 'pack_weight',
                    'default' => 100,
                    'type'    => 'number',
                    'desc'    => "",
                ]
            ],
        ];
    }

    public static function output() {

        $instance = self::instance();

        echo '<div class="wrap">';

        $instance->show_navigation();
        $instance->show_forms();

        echo '</div>';
    }
}
