<?php
class MBGHI_Admin {

	public function __construct() {

		$this->includes();

		add_action( 'admin_menu', [ $this, 'admin_menu' ], 20 );
		add_action( 'woocommerce_product_options_shipping', [ $this, 'product_options' ]);
		add_action( 'woocommerce_admin_process_product_object', [ $this, 'save_product_options' ] );

		add_filter( 'parent_file', [ $this, 'parent_file' ] );
		// add_filter( 'woocommerce_get_settings_shipping', [ $this, 'shipping_setting' ], 10, 2 );

	}

	public function admin_menu() {

		$capability = apply_filters( 'MBGHI_menu_capability', 'manage_woocommerce' );

		add_menu_page( 'حمل و نقل', 'حمل و نقل', $capability, 'MBGHI-tools', [
			'MBGHI_Settings_Sadr',
			'output',
		], MBGHI_URL . 'assets/images/MBGHI.png', '55.8' );

		$submenus = [
			10 => [
				'title'      => 'صدر',
				'capability' => $capability,
				'slug'       => 'MBGHI-sadr',
				'callback'   => [ 'MBGHI_Settings_Sadr', 'output' ],
			]
		];

		$submenus = apply_filters( 'MBGHI_submenu', $submenus );

		foreach ( $submenus as $submenu ) {
			add_submenu_page( 'MBGHI-tools', $submenu['title'], $submenu['title'], $submenu['capability'], $submenu['slug'], $submenu['callback'] );

			add_action( 'admin_init', function () use ( $submenu ) {
				$callback = $submenu['callback'][0] ?? null;
				if ( is_string( $callback ) && class_exists( $callback ) ) {
					call_user_func( [ $callback, 'instance' ] );
				}
			}, 5 );
		}

	}


	public function product_options() {
		global $product_object;
		$out_of_size = $product_object->get_meta( '_sadr_out_of_size' );
		$water_product = $product_object->get_meta( '_sadr_water_product' );
		$broken_product = $product_object->get_meta( '_sadr_broken_product' );
		$tax_discount = $product_object->get_meta( '_sadr_tax_discount' );
		$service_discount = $product_object->get_meta( '_sadr_service_discount' );
		$send_discount = $product_object->get_meta( '_sadr_send_discount' );
		?>
		<p class="form-field shipping_class_field">
			<label for="sadr-out-of-size">محصول خارج از اندازه</label>
			<input type="checkbox" id="sadr-out-of-size" name="sadr_out_of_size" <?php checked( $out_of_size, 'on' ); ?>>
		</p>

		<p class="form-field shipping_class_field">
			<label for="sadr-broken-product">محصول شکستنی</label>
			<input type="checkbox" id="sadr-broken-product" name="sadr_broken_product" <?php checked( $broken_product, 'on' ); ?>>
		</p>

		<p class="form-field shipping_class_field">
			<label for="sadr-water-product">محصول مایع</label>
			<input type="checkbox" id="sadr-water-product" name="sadr_water_product" <?php checked( $water_product, 'on' ); ?>>
		</p>

		<p class="form-field shipping_class_field">
			<label for="sadr-tax-discount">تخفیف مالیات</label>
			<input type="checkbox" id="sadr-tax-discount" name="sadr_tax_discount" <?php checked( $tax_discount, 'on' ); ?>>
		</p>

		<p class="form-field shipping_class_field">
			<label for="sadr-service-discount">تخفیف خدمات</label>
			<input type="checkbox" id="sadr-service-discount" name="sadr_service_discount" <?php checked( $service_discount, 'on' ); ?>>
		</p>

		<p class="form-field shipping_class_field">
			<label for="sadr-send-discount">تخفیف هزینه ارسال</label>
			<input type="checkbox" id="sadr-send-discount" name="sadr_send_discount" <?php checked( $send_discount, 'on' ); ?>>
		</p>
		<?php
	}


	public function save_product_options( $product ) {
		$out_of_size = isset( $_POST[ 'sadr_out_of_size' ] ) ? $_POST[ 'sadr_out_of_size' ] : '';
		$water_product = isset( $_POST[ 'sadr_water_product' ] ) ? $_POST[ 'sadr_water_product' ] : '';
		$broken_product = isset( $_POST[ 'sadr_broken_product' ] ) ? $_POST[ 'sadr_broken_product' ] : '';
		$tax_discount = isset( $_POST[ 'sadr_tax_discount' ] ) ? $_POST[ 'sadr_tax_discount' ] : '';
		$service_discount = isset( $_POST[ 'sadr_service_discount' ] ) ? $_POST[ 'sadr_service_discount' ] : '';
		$send_discount = isset( $_POST[ 'sadr_send_discount' ] ) ? $_POST[ 'sadr_send_discount' ] : '';

		$product->update_meta_data( '_sadr_out_of_size', $out_of_size );
		$product->update_meta_data( '_sadr_water_product', $water_product );
		$product->update_meta_data( '_sadr_broken_product', $broken_product );
		$product->update_meta_data( '_sadr_tax_discount', $tax_discount );
		$product->update_meta_data( '_sadr_service_discount', $service_discount );
		$product->update_meta_data( '_sadr_send_discount', $send_discount );
	}


	public function parent_file( $parent_file ) {

		if ( ! isset( $_GET['taxonomy'] ) || $_GET['taxonomy'] != 'state_city' ) {
			return $parent_file;
		}

		return 'MBGHI-tools';
	}

	public function includes() {
		include 'cls-settings.php';
		include 'cls-sadr.php';
	}

}

new MBGHI_Admin();
