jQuery(document).ready(function ($) {

    const queryString = window.location.search;
    const urlParams = new URLSearchParams(queryString);
    let MBGHI_button_submit = $("#MBGHI-tapin-submit");
    let MBGHI_button_ship = $("#MBGHI-tapin-ship");

    MBGHI_button_submit.click(function () {
        MBGHI_change_status('MBGHI-packaged');
    });

    MBGHI_button_ship.click(function () {
        MBGHI_change_status('MBGHI-ready-to-ship');
    });

    function MBGHI_change_status(status) {

        // Start
        MBGHI_button_submit.attr('disabled', 'disabled');
        MBGHI_button_ship.attr('disabled', 'disabled');
        $('.MBGHI-tips').html('');

        MBGHI_change_status_ajax(status);
    }

    function MBGHI_change_status_ajax(status) {

        let id = urlParams.get('post');

        let data = {
            'action': 'MBGHI_change_order_status',
            'status': status,
            'weight': $('#tapin_weight').val(),
            'content_type': $('#tapin_content_type').val(),
            'id': id
        };

        $(".MBGHI-tips").html(`
                        <mark class="order-status">
                            <span>...</span>
                        </mark>
                    `);

        $.post(ajaxurl, data).then(function (response) {

            response = JSON.parse(response);

            if (response.success) {

                $(".MBGHI-tips").html(`
                                <mark class="order-status status-processing">
                                    <span>${response.message}</span>
                                </mark>
                            `);

                setTimeout(function () {
                    location.reload();
                }, 3000);

            } else {

                $(".MBGHI-tips").html(`
                                <mark class="order-status status-MBGHI-returned">
                                    <span>خطا در پردازش</span>
                                </mark>
                            `);

                $(".MBGHI-tips").append(`
                                <mark class="order-status status-MBGHI-returned MBGHI-tips"
                                        style="margin-top: 10px; font-size: 11px;">
                                    <span>
                                        ${response.message}
                                    </span>
                                </mark>
                            `);

            }

            MBGHI_button_submit.removeAttr('disabled');
            MBGHI_button_ship.removeAttr('disabled');
        });

    }
});