jQuery(function ($) {

    function MBGHI_selectWoo(element) {
        let select2_args = {
            placeholder: element.attr('data-placeholder') || element.attr('placeholder') || '',
            width: '100%'
        };

        element.selectWoo(select2_args);
    }

    function MBGHI_state_changed(type, state_id) {

        let city_element = $('select#' + type + '_city');

        city_element.html('<option value="0">در حال بارگزاری لیست شهرها...</option>');

        let data = {
            'action': 'mahdiy_load_cities',
            'state_id': state_id,
            'type': type
        };

        $.post(MBGHI_settings.ajax_url, data, function (response) {
            city_element.html(response);
        });

        MBGHI_selectWoo(city_element);
        $('p#' + type + '_district_field').slideUp();
        $('select#' + type + '_district').html('');
    }

    function MBGHI_city_changed(type, city_id) {

        let district_element = $('select#' + type + '_district');

        district_element.html('<option value="0">در حال بارگزاری لیست محله‌ها...</option>');

        let data = {
            'action': 'mahdiy_load_districts',
            'city_id': city_id,
            'type': type
        };

        $.post(MBGHI_settings.ajax_url, data, function (response) {
            if (response.trim() === "") {
                $('p#' + type + '_district_field').slideUp();
            } else {
                $('p#' + type + '_district_field').slideDown();
            }

            district_element.html(response);
            $('body').trigger('update_checkout');
        });

        MBGHI_selectWoo(district_element);
    }

    $("select[id$='_state']").on('select2:select', function (e) {
        let type = $(this).attr('id').indexOf('billing') !== -1 ? 'billing' : 'shipping';
        let data = e.params.data;
        MBGHI_state_changed(type, data.id);
    });

    $("select[id$='_city']").on('select2:select', function (e) {
        let type = $(this).attr('id').indexOf('billing') !== -1 ? 'billing' : 'shipping';
        let data = e.params.data;
        MBGHI_city_changed(type, data.id);
    });

    $(document.body).on('select2:select', "select[id$='_district']", function (e) {
        $('body').trigger('update_checkout');
    });

    MBGHI_settings.types.forEach(type => {
        MBGHI_selectWoo($('select#' + type + '_state'));
        MBGHI_selectWoo($('select#' + type + '_city'));
        MBGHI_selectWoo($('select#' + type + '_district'));
    });

    $('form.checkout').on('change', 'input[name^="payment_method"]', function () {
        $('body').trigger('update_checkout');
    });

});